/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class PathTraversalParameterGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> attackTypeGen = Generators.integers((int)1, (int)8);
    private final TypedGenerator<Integer> depthGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> targetFileSelector = Generators.integers((int)1, (int)10);
    private final TypedGenerator<Boolean> caseVariationGen = Generators.booleans();

    public String next() {
        return switch ((Integer)this.attackTypeGen.next()) {
            case 1 -> this.generateBasicEncodedTraversal();
            case 2 -> this.generateDoubleEncodedTraversal();
            case 3 -> this.generateMixedEncodingTraversal();
            case 4 -> this.generateWindowsStyleTraversal();
            case 5 -> this.generateDeepTraversal();
            case 6 -> this.generateQuadDotBypass();
            case 7 -> this.generateUtf8OverlongTraversal();
            case 8 -> this.generateTripleEncodedTraversal();
            default -> this.generateBasicEncodedTraversal();
        };
    }

    private String generateBasicEncodedTraversal() {
        int depth = (Integer)this.depthGen.next();
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("..%2F");
        }
        String encodedTarget = targetFile.replace("/", "%2F");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateDoubleEncodedTraversal() {
        int depth = (Integer)this.depthGen.next();
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("%2E%2E%2F");
        }
        String encodedTarget = targetFile.replace("/", "%2F");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateMixedEncodingTraversal() {
        int depth = (Integer)this.depthGen.next();
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            if (((Boolean)this.caseVariationGen.next()).booleanValue()) {
                pattern.append("%2e%2e%2f");
                continue;
            }
            pattern.append("%2E%2E%2F");
        }
        String encodedTarget = targetFile.replace("/", "%2f");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateWindowsStyleTraversal() {
        int depth = (Integer)this.depthGen.next();
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            if (((Boolean)this.caseVariationGen.next()).booleanValue()) {
                pattern.append("..%5c");
                continue;
            }
            pattern.append("%2e%2e%5c");
        }
        String encodedTarget = targetFile.replace("/", "%5c").replace("\\", "%5c");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateDeepTraversal() {
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        int deepDepth = (Integer)Generators.integers((int)3, (int)6).next();
        for (int i = 0; i < deepDepth; ++i) {
            pattern.append("%2e%2e%2f");
        }
        String encodedTarget = targetFile.replace("/", "%2f");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateQuadDotBypass() {
        int depth = (Integer)this.depthGen.next();
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("....%2f");
        }
        String encodedTarget = targetFile.replace("/", "%2f");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateUtf8OverlongTraversal() {
        int depth = (Integer)this.depthGen.next();
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            if (((Boolean)this.caseVariationGen.next()).booleanValue()) {
                pattern.append("..%c0%af");
                continue;
            }
            pattern.append("%c0%ae%c0%ae%c0%af");
        }
        String encodedTarget = targetFile.replace("/", "%c0%af");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateTripleEncodedTraversal() {
        int depth = (Integer)this.depthGen.next();
        String targetFile = this.generateTargetFile();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("%252e%252e%252f");
        }
        String encodedTarget = targetFile.replace("/", "%252f");
        pattern.append(encodedTarget);
        return pattern.toString();
    }

    private String generateTargetFile() {
        return switch ((Integer)this.targetFileSelector.next()) {
            case 1 -> "etc/passwd";
            case 2 -> "config";
            case 3 -> "windows";
            case 4 -> "root";
            case 5 -> "shadow";
            case 6 -> "etc/hosts";
            case 7 -> "boot.ini";
            case 8 -> "var/log/auth.log";
            case 9 -> "windows/system32/config/sam";
            case 10 -> "root/.ssh/id_rsa";
            default -> "etc/passwd";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

