/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class InvalidURLGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> malformationTypeGen = Generators.integers((int)1, (int)10);
    private final TypedGenerator<Integer> protocolSelector = Generators.integers((int)1, (int)6);
    private final TypedGenerator<Integer> hostSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> pathSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> encodingSelector = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Boolean> combineGen = Generators.booleans();

    public String next() {
        Object baseUrl;
        switch ((Integer)this.malformationTypeGen.next()) {
            case 1: {
                Object object = this.createProtocolIssue();
                break;
            }
            case 2: {
                Object object = this.createHostIssue();
                break;
            }
            case 3: {
                Object object = this.createPathIssue();
                break;
            }
            case 4: {
                Object object = this.createQueryParameterIssue();
                break;
            }
            case 5: {
                Object object = this.createFragmentIssue();
                break;
            }
            case 6: {
                Object object = this.createPortIssue();
                break;
            }
            case 7: {
                Object object = this.createSpecialCharacterIssue();
                break;
            }
            case 8: {
                Object object = this.createEncodingIssue();
                break;
            }
            case 9: {
                Object object = this.createLengthIssue();
                break;
            }
            case 10: {
                Object object = this.createMixedIssue();
                break;
            }
            default: {
                Object object = baseUrl = this.createProtocolIssue();
            }
        }
        if (((Boolean)this.combineGen.next()).booleanValue() && ((String)baseUrl).startsWith("http") && ((String)baseUrl).length() > 10 && !((String)baseUrl).contains("?")) {
            baseUrl = (String)baseUrl + "%invalid%encoding";
        }
        return baseUrl;
    }

    private String createProtocolIssue() {
        String host = this.generateHost();
        String path = this.generatePath();
        return switch ((Integer)Generators.integers((int)1, (int)8).next()) {
            case 1 -> "htp://" + host + "/" + path;
            case 2 -> "://" + host + "/" + path;
            case 3 -> "http:/example.com/path";
            case 4 -> "http:///" + host + "/" + path;
            case 5 -> "javascript:alert('xss')";
            case 6 -> "data:text/html,<script>alert(1)</script>";
            case 7 -> "ftp://" + host + "/" + path;
            case 8 -> "file://" + host + "/" + path;
            default -> "htp://" + host + "/" + path;
        };
    }

    private String createHostIssue() {
        String protocol = this.generateProtocol();
        String path = this.generatePath();
        String host = this.generateHost();
        return switch ((Integer)Generators.integers((int)1, (int)6).next()) {
            case 1 -> "http://";
            case 2 -> protocol + ":///" + path;
            case 3 -> "http://exam ple.com/path";
            case 4 -> "http://example..com/path";
            case 5 -> "http://.example.com/path";
            case 6 -> protocol + "://" + host + "./" + path;
            default -> "http://";
        };
    }

    private String createPathIssue() {
        String protocol = this.generateProtocol();
        String host = this.generateHost();
        String path = this.generatePath();
        return switch ((Integer)Generators.integers((int)1, (int)3).next()) {
            case 1 -> protocol + "://" + host + "//" + path;
            case 2 -> protocol + "://" + host + "/" + path + "//file";
            case 3 -> protocol + "://" + host + "/" + path + "/";
            default -> protocol + "://" + host + "//" + path;
        };
    }

    private String createQueryParameterIssue() {
        String baseUrl = "http://" + this.generateHost() + "/" + this.generatePath();
        return switch ((Integer)Generators.integers((int)1, (int)7).next()) {
            case 1 -> baseUrl + "?";
            case 2 -> baseUrl + "?=value";
            case 3 -> baseUrl + "?param=";
            case 4 -> baseUrl + "?param";
            case 5 -> baseUrl + "?param=val&";
            case 6 -> baseUrl + "?&param=val";
            case 7 -> baseUrl + "?param=val&&other=val";
            default -> baseUrl + "?";
        };
    }

    private String createFragmentIssue() {
        String baseUrl = "http://" + this.generateHost() + "/" + this.generatePath();
        return switch ((Integer)Generators.integers((int)1, (int)2).next()) {
            case 1 -> baseUrl + "#";
            case 2 -> baseUrl + "##fragment";
            default -> baseUrl + "#";
        };
    }

    private String createPortIssue() {
        String host = this.generateHost();
        String path = this.generatePath();
        return switch ((Integer)Generators.integers((int)1, (int)4).next()) {
            case 1 -> "http://" + host + ":/" + path;
            case 2 -> "http://" + host + ":99999/" + path;
            case 3 -> "http://" + host + ":abc/" + path;
            case 4 -> "http://" + host + ":-80/" + path;
            default -> "http://" + host + ":/" + path;
        };
    }

    private String createSpecialCharacterIssue() {
        return switch ((Integer)Generators.integers((int)1, (int)6).next()) {
            case 1 -> "http://example.com/path with spaces";
            case 2 -> "http://example.com/path[bracket]";
            case 3 -> "http://example.com/path{brace}";
            case 4 -> "http://example.com/path|pipe";
            case 5 -> "http://example.com/path\\backslash";
            case 6 -> "http://example.com/path\\with\\backslashes";
            default -> "http://example.com/path with spaces";
        };
    }

    private String createEncodingIssue() {
        String baseUrl = "http://" + this.generateHost() + "/" + this.generatePath();
        String encoding = this.generateInvalidEncoding();
        return baseUrl + encoding + "encoding";
    }

    private String createLengthIssue() {
        String baseUrl = "http://" + this.generateHost() + "/";
        StringBuilder longPath = new StringBuilder();
        for (int i = 0; i < 300; ++i) {
            longPath.append("very_long_path_component_");
        }
        return baseUrl + String.valueOf(longPath);
    }

    private String createMixedIssue() {
        return switch ((Integer)Generators.integers((int)1, (int)6).next()) {
            case 1, 2 -> "://example..com//path??param=val##fragment";
            case 3 -> "";
            case 4 -> "   ";
            case 5 -> "not-a-url-at-all";
            case 6 -> "file://local/path";
            default -> "://example..com//path??param=val##fragment";
        };
    }

    private String generateProtocol() {
        return switch ((Integer)this.protocolSelector.next()) {
            case 1 -> "http";
            case 2 -> "https";
            case 3 -> "ftp";
            case 4 -> "file";
            case 5 -> "javascript";
            case 6 -> "data";
            default -> "http";
        };
    }

    private String generateHost() {
        return switch ((Integer)this.hostSelector.next()) {
            case 1 -> "example.com";
            case 2 -> "test.org";
            case 3 -> "site.net";
            case 4 -> "domain.edu";
            default -> "example.com";
        };
    }

    private String generatePath() {
        return switch ((Integer)this.pathSelector.next()) {
            case 1 -> "path";
            case 2 -> "file";
            case 3 -> "resource";
            case 4 -> "document";
            default -> "path";
        };
    }

    private String generateInvalidEncoding() {
        return switch ((Integer)this.encodingSelector.next()) {
            case 1 -> "%";
            case 2 -> "%2";
            case 3 -> "%ZZ";
            case 4 -> "%GG";
            case 5 -> "%invalid";
            default -> "%";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

