/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.injection;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import java.lang.invoke.StringConcatFactory;

public class ProtocolHandlerAttackGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> attackCategoryGen = Generators.integers((int)1, (int)17);
    private final TypedGenerator<Integer> hostSelector = Generators.integers((int)1, (int)6);
    private final TypedGenerator<Integer> pathSelector = Generators.integers((int)1, (int)6);

    public String next() {
        return switch ((Integer)this.attackCategoryGen.next()) {
            case 1 -> this.generateJavaScriptProtocolAttack();
            case 2 -> this.generateDataUriExploitation();
            case 3 -> this.generateFileProtocolAttack();
            case 4 -> this.generateCustomProtocolSchemes();
            case 5 -> this.generateProtocolConfusionAttacks();
            case 6 -> this.generateProtocolInjection();
            case 7 -> this.generateMalformedProtocolSchemes();
            case 8 -> this.generateProtocolCaseManipulation();
            case 9 -> this.generateProtocolWithSpecialCharacters();
            case 10 -> this.generateDoubleProtocolSchemes();
            case 11 -> this.generateProtocolWithAuthBypass();
            case 12 -> this.generateProtocolWithPortManipulation();
            case 13 -> this.generateNestedProtocolAttacks();
            case 14 -> this.generateProtocolWithPathTraversal();
            case 15 -> this.generateProtocolHandlerExploitation();
            case 16 -> this.generateProtocolWithFragmentManipulation();
            case 17 -> this.generateProtocolEncodingAttacks();
            default -> this.generateJavaScriptProtocolAttack();
        };
    }

    private String generateJavaScriptProtocolAttack() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        String path = this.generatePath();
        return switch (type) {
            case 1 -> "javascript:alert('XSS')" + path;
            case 2 -> "javascript:eval(String.fromCharCode(97,108,101,114,116,40,39,88,83,83,39,41))/admin";
            case 3 -> "javascript:window.location='http://evil.com'/../../config";
            case 4 -> "javascript:document.location.href='malicious.com'/../sensitive";
            case 5 -> "javascript:fetch('/../../etc/passwd').then(r=>r.text()).then(console.log)";
            case 6 -> "javascript://comment%0Aalert('XSS')/../etc/hosts";
            default -> "javascript:alert('XSS')" + path;
        };
    }

    private String generateDataUriExploitation() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        String path = this.generatePath();
        return switch (type) {
            case 1 -> "data:text/html,<script>alert('XSS')</script>" + path;
            case 2 -> "data:application/javascript,alert('XSS')/../admin/config";
            case 3 -> "data:text/html;base64,PHNjcmlwdD5hbGVydCgnWFNTJyk8L3NjcmlwdD4=/../etc/hosts";
            case 4 -> "data:image/svg+xml,<svg><script>alert('XSS')</script></svg>/../../sensitive";
            case 5 -> "data:text/plain,../../../etc/passwd";
            case 6 -> "data:,../../admin/config";
            default -> "data:text/html,<script>alert('XSS')</script>" + path;
        };
    }

    private String generateFileProtocolAttack() {
        int type = (Integer)Generators.integers((int)1, (int)8).next();
        return switch (type) {
            case 1 -> "file:///../../../etc/passwd";
            case 2 -> "file:////etc/passwd/../../../sensitive";
            case 3 -> "file://../../../etc/hosts";
            case 4 -> "file://localhost/../../../etc/passwd";
            case 5 -> "file:///c:/../../windows/win.ini";
            case 6 -> "file://./../../etc/shadow";
            case 7 -> "file://.././../etc/passwd";
            case 8 -> "file:///etc/../../../passwd";
            default -> "file:///../../../etc/passwd";
        };
    }

    private String generateCustomProtocolSchemes() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        String host = this.generateHost();
        String path = this.generatePath();
        return switch (type) {
            case 1 -> "custom://" + host + path;
            case 2 -> "malware://" + host + "/../../admin/config";
            case 3 -> "exploit://" + host + "/../etc/hosts";
            case 4 -> "backdoor://" + host + "/../../sensitive";
            case 5 -> "trojan://" + host + "/../admin";
            case 6 -> "virus://" + host + "/../../config";
            default -> "custom://" + host + path;
        };
    }

    private String generateProtocolConfusionAttacks() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://javascript:alert('XSS')@" + host + "/../../../etc/passwd";
            case 2 -> "https://data:text/html,<script>@" + host + "/../../config";
            case 3 -> "ftp://file@" + host + "/../../../admin/config";
            case 4 -> "mailto://javascript:alert('XSS')@" + host + "/../sensitive";
            case 5 -> "tel://data:text/html@" + host + "/../../etc/hosts";
            default -> "http://javascript:alert('XSS')@" + host + "/../../../etc/passwd";
        };
    }

    private String generateProtocolInjection() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://" + host + "#javascript:alert('XSS')/../../../etc/passwd";
            case 2 -> "https://" + host + "?redirect=javascript:alert('XSS')/../../config";
            case 3 -> "http://" + host + "/path?url=file:///etc/passwd";
            case 4 -> "https://" + host + "/redirect?to=data:text/html,<script>/admin";
            case 5 -> "http://" + host + "/proxy?target=javascript:alert(1)/../sensitive";
            default -> "http://" + host + "#javascript:alert('XSS')/../../../etc/passwd";
        };
    }

    private String generateMalformedProtocolSchemes() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "ht tp://" + host + "/../../../etc/passwd";
            case 2 -> "htt p://" + host + "/../../admin/config";
            case 3 -> "http ://" + host + "/../etc/hosts";
            case 4 -> "http:////" + host + "/../../sensitive";
            case 5 -> "http:///" + host + "/../admin";
            case 6 -> "http::" + host + "/../../etc/passwd";
            default -> "ht tp://" + host + "/../../../etc/passwd";
        };
    }

    private String generateProtocolCaseManipulation() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        return switch (type) {
            case 1 -> "HTTP://EVIL.COM/../../../etc/passwd";
            case 2 -> "hTtP://MaLiCiOuS.cOm/../../admin/config";
            case 3 -> "HTTPS://ATTACKER.COM/../etc/hosts";
            case 4 -> "FTP://EVIL.SITE/../../sensitive";
            case 5 -> "JAVASCRIPT:alert('XSS')/../admin";
            case 6 -> "DATA:text/html,<script>/../../etc/passwd";
            default -> "HTTP://EVIL.COM/../../../etc/passwd";
        };
    }

    private String generateProtocolWithSpecialCharacters() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001/../../../etc/passwd", "http\u0001://"}, (String)host);
            case 2 -> "http\u0000://" + host + "/../../admin/config";
            case 3 -> "http\n://attacker.com/../etc/hosts";
            case 4 -> "http\\\n\\\n://evil.site/../../sensitive";
            case 5 -> "http\t://" + host + "/../admin";
            case 6 -> "http ://" + host + "/../../etc/passwd";
            default -> StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001/../../../etc/passwd", "http\u0001://"}, (String)host);
        };
    }

    private String generateDoubleProtocolSchemes() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://http://" + host + "/../../../etc/passwd";
            case 2 -> "https://https://" + host + "/../../admin/config";
            case 3 -> "ftp://ftp://" + host + "/../etc/hosts";
            case 4 -> "javascript://javascript:alert('XSS')/../../sensitive";
            case 5 -> "data://data:text/html,<script>alert(1)</script>/../admin";
            default -> "http://http://" + host + "/../../../etc/passwd";
        };
    }

    private String generateProtocolWithAuthBypass() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://admin:password@" + host + "/../../../etc/passwd";
            case 2 -> "https://root:toor@" + host + "/../../admin/config";
            case 3 -> "ftp://user:pass@" + host + "/../etc/hosts";
            case 4 -> "http://:%40@" + host + "/../../sensitive";
            case 5 -> "https://user@:@" + host + "/../admin";
            default -> "http://admin:password@" + host + "/../../../etc/passwd";
        };
    }

    private String generateProtocolWithPortManipulation() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://" + host + ":0/../../../etc/passwd";
            case 2 -> "https://" + host + ":65536/../../admin/config";
            case 3 -> "http://" + host + ":-80/../etc/hosts";
            case 4 -> "https://" + host + ":99999/../../sensitive";
            case 5 -> "ftp://" + host + ":21;ls/../../admin";
            default -> "http://" + host + ":0/../../../etc/passwd";
        };
    }

    private String generateNestedProtocolAttacks() {
        int type = (Integer)Generators.integers((int)1, (int)4).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://" + host + "/redirect?url=javascript:alert('XSS')/../etc/passwd";
            case 2 -> "https://" + host + "/proxy?target=file:///etc/shadow";
            case 3 -> "http://" + host + "/gateway?dest=data:text/html,<script>/admin";
            case 4 -> "https://" + host + "/forward?to=custom://malicious/../../config";
            default -> "http://" + host + "/redirect?url=javascript:alert('XSS')/../etc/passwd";
        };
    }

    private String generateProtocolWithPathTraversal() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://" + host + "/../../../etc/passwd";
            case 2 -> "https://" + host + "/../../admin/config";
            case 3 -> "ftp://" + host + "/../etc/hosts";
            case 4 -> "file://localhost/../../../etc/passwd";
            case 5 -> "javascript:location='http://evil.com'/../sensitive";
            default -> "http://" + host + "/../../../etc/passwd";
        };
    }

    private String generateProtocolHandlerExploitation() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        String host = this.generateHost();
        String path = this.generatePath();
        return switch (type) {
            case 1 -> "gopher://" + host + path;
            case 2 -> "ldap://" + host + "/../../admin/config";
            case 3 -> "dict://" + host + "/../etc/hosts";
            case 4 -> "tftp://" + host + "/../../sensitive";
            case 5 -> "imap://" + host + "/../admin";
            case 6 -> "pop3://" + host + "/../../etc/passwd";
            default -> "gopher://" + host + path;
        };
    }

    private String generateProtocolWithFragmentManipulation() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "http://" + host + "#/../../../etc/passwd";
            case 2 -> "https://" + host + "#/../../admin/config";
            case 3 -> "javascript:alert('XSS')#/../etc/hosts";
            case 4 -> "data:text/html,<script>alert(1)</script>#/../../sensitive";
            case 5 -> "file:///etc/passwd#/../admin";
            default -> "http://" + host + "#/../../../etc/passwd";
        };
    }

    private String generateProtocolEncodingAttacks() {
        int type = (Integer)Generators.integers((int)1, (int)5).next();
        String host = this.generateHost();
        return switch (type) {
            case 1 -> "%68%74%74%70://" + host + "/../../../etc/passwd";
            case 2 -> "%6a%61%76%61%73%63%72%69%70%74:alert('XSS')/../admin";
            case 3 -> "%64%61%74%61:text/html,<script>/../../etc/hosts";
            case 4 -> "%66%69%6c%65:///../../../etc/passwd";
            case 5 -> "h%74%74p://" + host + "/../../sensitive";
            default -> "%68%74%74%70://" + host + "/../../../etc/passwd";
        };
    }

    private String generateHost() {
        return switch ((Integer)this.hostSelector.next()) {
            case 1 -> "evil.com";
            case 2 -> "malicious.com";
            case 3 -> "attacker.com";
            case 4 -> "evil.site";
            case 5 -> "malicious.host";
            case 6 -> "evil.domain";
            default -> "evil.com";
        };
    }

    private String generatePath() {
        return switch ((Integer)this.pathSelector.next()) {
            case 1 -> "../../../etc/passwd";
            case 2 -> "/../../admin/config";
            case 3 -> "/../etc/hosts";
            case 4 -> "/../../sensitive";
            case 5 -> "/../admin";
            case 6 -> "/../../config";
            default -> "../../../etc/passwd";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

