/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.header;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class ValidHTTPHeaderValueGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> headerTypeSelector = Generators.integers((int)1, (int)9);
    private final TypedGenerator<Integer> contentTypeSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> charsetSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> encodingSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> languageSelector = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> browserSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> osSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> connectionSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> cacheDirectiveSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> originSelector = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> ipSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Boolean> contextSelector = Generators.booleans();
    private final TypedGenerator<Integer> ageValues = Generators.integers((int)60, (int)86400);
    private final TypedGenerator<Double> qualityValues = Generators.doubles((double)0.1, (double)1.0);
    private final TypedGenerator<String> tokenGenerator = Generators.letterStrings((int)32, (int)64);
    private final TypedGenerator<String> credentialsGenerator = Generators.letterStrings((int)16, (int)32);
    private final TypedGenerator<Integer> browserVersionGenerator = Generators.integers((int)80, (int)120);

    public String next() {
        return switch ((Integer)this.headerTypeSelector.next()) {
            case 1 -> this.generateAuthorizationValue();
            case 2 -> this.generateContentTypeValue();
            case 3 -> this.generateAcceptEncodingValue();
            case 4 -> this.generateAcceptLanguageValue();
            case 5 -> this.generateCacheControlValue();
            case 6 -> this.generateUserAgentValue();
            case 7 -> this.generateConnectionValue();
            case 8 -> this.generateOriginValue();
            case 9 -> this.generateForwardedForValue();
            default -> this.generateContentTypeValue();
        };
    }

    private String generateAuthorizationValue() {
        int authType = (Integer)Generators.integers((int)0, (int)1).next();
        return switch (authType) {
            case 0 -> this.generateBearerToken();
            case 1 -> this.generateBasicAuth();
            default -> this.generateBearerToken();
        };
    }

    private String generateBearerToken() {
        String token = (String)this.tokenGenerator.next();
        return "Bearer " + token;
    }

    private String generateBasicAuth() {
        String credentials = (String)this.credentialsGenerator.next();
        return "Basic " + credentials;
    }

    private String generateContentTypeValue() {
        String contentType = this.generateContentType();
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            String charset = this.generateCharset();
            return contentType + "; charset=" + charset;
        }
        return contentType;
    }

    private String generateContentType() {
        return switch ((Integer)this.contentTypeSelector.next()) {
            case 1 -> "application/json";
            case 2 -> "text/html";
            case 3 -> "application/xml";
            case 4 -> "text/plain";
            default -> "application/json";
        };
    }

    private String generateCharset() {
        return switch ((Integer)this.charsetSelector.next()) {
            case 1 -> "utf-8";
            case 2 -> "iso-8859-1";
            case 3 -> "us-ascii";
            case 4 -> "utf-16";
            default -> "utf-8";
        };
    }

    private String generateAcceptEncodingValue() {
        StringBuilder encoding = new StringBuilder();
        encoding.append(this.generateEncoding());
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            encoding.append(", ").append(this.generateEncoding());
            if (((Boolean)this.contextSelector.next()).booleanValue()) {
                encoding.append(", ").append(this.generateEncoding());
            }
        }
        return encoding.toString();
    }

    private String generateEncoding() {
        return switch ((Integer)this.encodingSelector.next()) {
            case 1 -> "gzip";
            case 2 -> "deflate";
            case 3 -> "br";
            case 4 -> "compress";
            default -> "gzip";
        };
    }

    private String generateAcceptLanguageValue() {
        Object language = this.generateLanguage();
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            double quality = (Double)this.qualityValues.next();
            language = (String)language + ";q=" + "%.1f".formatted(quality);
            if (((Boolean)this.contextSelector.next()).booleanValue()) {
                String secondLang = this.generateLanguage();
                double secondQuality = (Double)this.qualityValues.next();
                language = (String)language + "," + secondLang + ";q=" + "%.1f".formatted(secondQuality);
            }
        }
        return language;
    }

    private String generateLanguage() {
        return switch ((Integer)this.languageSelector.next()) {
            case 1 -> "en-US";
            case 2 -> "en";
            case 3 -> "de";
            case 4 -> "fr";
            case 5 -> "es";
            default -> "en-US";
        };
    }

    private String generateCacheControlValue() {
        String directive = this.generateCacheDirective();
        if (((Boolean)this.contextSelector.next()).booleanValue() && !directive.contains("=")) {
            int age = (Integer)this.ageValues.next();
            return directive + ", max-age=" + age;
        }
        return directive;
    }

    private String generateCacheDirective() {
        return switch ((Integer)this.cacheDirectiveSelector.next()) {
            case 1 -> "no-cache";
            case 2 -> "max-age=3600";
            case 3 -> "must-revalidate";
            case 4 -> "private";
            default -> "no-cache";
        };
    }

    private String generateUserAgentValue() {
        String browser = this.generateBrowser();
        String os = this.generateOS();
        if ("Mozilla/5.0".equals(browser)) {
            return browser + " (compatible; " + this.generateCompatibleBrowser() + "; " + os + ")";
        }
        return browser + "/" + String.valueOf(this.browserVersionGenerator.next()) + ".0 (" + os + ")";
    }

    private String generateBrowser() {
        return switch ((Integer)this.browserSelector.next()) {
            case 1 -> "Mozilla/5.0";
            case 2 -> "Chrome";
            case 3 -> "Safari";
            case 4 -> "Edge";
            default -> "Mozilla/5.0";
        };
    }

    private String generateOS() {
        return switch ((Integer)this.osSelector.next()) {
            case 1 -> "Windows NT 6.2";
            case 2 -> "Macintosh";
            case 3 -> "X11; Linux";
            case 4 -> "Android";
            default -> "Windows NT 6.2";
        };
    }

    private String generateCompatibleBrowser() {
        int compatType = (Integer)Generators.integers((int)1, (int)3).next();
        return switch (compatType) {
            case 1 -> "MSIE 10.0";
            case 2 -> "Chrome/91.0";
            case 3 -> "Safari/537.36";
            default -> "MSIE 10.0";
        };
    }

    private String generateConnectionValue() {
        return switch ((Integer)this.connectionSelector.next()) {
            case 1 -> "keep-alive";
            case 2 -> "close";
            case 3 -> "upgrade";
            default -> "keep-alive";
        };
    }

    private String generateOriginValue() {
        String origin = this.generateOrigin();
        if ("cors".equals(origin)) {
            return "https://example.com";
        }
        return origin;
    }

    private String generateOrigin() {
        return switch ((Integer)this.originSelector.next()) {
            case 1 -> "same-origin";
            case 2 -> "cors";
            case 3 -> "no-cors";
            default -> "same-origin";
        };
    }

    private String generateForwardedForValue() {
        StringBuilder ips = new StringBuilder();
        ips.append(this.generateIP());
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            ips.append(", ").append(this.generateIP());
        }
        return ips.toString();
    }

    private String generateIP() {
        return switch ((Integer)this.ipSelector.next()) {
            case 1 -> "192.168.1.1";
            case 2 -> "10.0.0.1";
            case 3 -> "172.16.0.1";
            case 4 -> "127.0.0.1";
            default -> "192.168.1.1";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

