/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.header;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class ValidHTTPHeaderNameGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> headerTypeGen = Generators.integers((int)1, (int)7);
    private final TypedGenerator<Integer> standardHeaderGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> acceptHeaderGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> contentHeaderGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> cookieHeaderGen = Generators.integers((int)1, (int)2);
    private final TypedGenerator<Integer> navigationHeaderGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> connectionHeaderGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Boolean> customVariationGen = Generators.booleans();

    public String next() {
        return switch ((Integer)this.headerTypeGen.next()) {
            case 1 -> this.generateStandardHeader();
            case 2 -> this.generateAcceptHeader();
            case 3 -> this.generateContentHeader();
            case 4 -> this.generateCustomHeader();
            case 5 -> this.generateCookieHeader();
            case 6 -> this.generateNavigationHeader();
            case 7 -> this.generateConnectionHeader();
            default -> this.generateStandardHeader();
        };
    }

    private String generateStandardHeader() {
        return switch ((Integer)this.standardHeaderGen.next()) {
            case 1 -> "Authorization";
            case 2 -> "Content-Type";
            case 3 -> "User-Agent";
            case 4 -> "Host";
            default -> "Authorization";
        };
    }

    private String generateAcceptHeader() {
        return switch ((Integer)this.acceptHeaderGen.next()) {
            case 1 -> "Accept";
            case 2 -> "Accept-Language";
            case 3 -> "Accept-Encoding";
            default -> "Accept";
        };
    }

    private String generateContentHeader() {
        return switch ((Integer)this.contentHeaderGen.next()) {
            case 1 -> "Content-Length";
            case 2 -> "Content-Encoding";
            case 3 -> "Cache-Control";
            default -> "Content-Length";
        };
    }

    private String generateCookieHeader() {
        return switch ((Integer)this.cookieHeaderGen.next()) {
            case 1 -> "Cookie";
            case 2 -> "Set-Cookie";
            default -> "Cookie";
        };
    }

    private String generateNavigationHeader() {
        return switch ((Integer)this.navigationHeaderGen.next()) {
            case 1 -> "Origin";
            case 2 -> "Referer";
            case 3 -> "Location";
            default -> "Origin";
        };
    }

    private String generateConnectionHeader() {
        return switch ((Integer)this.connectionHeaderGen.next()) {
            case 1 -> "Connection";
            case 2 -> "Keep-Alive";
            case 3 -> "Upgrade";
            default -> "Connection";
        };
    }

    private String generateCustomHeader() {
        String prefix = this.generateCustomPrefix();
        String suffix = this.generateCustomSuffix();
        if (((Boolean)this.customVariationGen.next()).booleanValue()) {
            String middle = this.generateMiddlePart();
            return prefix + middle + "-" + suffix;
        }
        return prefix + suffix;
    }

    private String generateCustomPrefix() {
        int type = (Integer)Generators.integers((int)1, (int)4).next();
        return switch (type) {
            case 1 -> "X-";
            case 2 -> "X-Custom-";
            case 3 -> "X-API-";
            case 4 -> "X-Requested-";
            default -> "X-";
        };
    }

    private String generateCustomSuffix() {
        int type = (Integer)Generators.integers((int)1, (int)4).next();
        return switch (type) {
            case 1 -> "Key";
            case 2 -> "With";
            case 3 -> "For";
            case 4 -> "Header-Name";
            default -> "Key";
        };
    }

    private String generateMiddlePart() {
        int type = (Integer)Generators.integers((int)1, (int)6).next();
        return switch (type) {
            case 1 -> "Request";
            case 2 -> "Response";
            case 3 -> "Client";
            case 4 -> "Server";
            case 5 -> "Auth";
            case 6 -> "Session";
            default -> "Request";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

