/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.header;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class InvalidHTTPHeaderNameGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> invalidTypeSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> baseHeaderSelector = Generators.integers((int)1, (int)9);

    public String next() {
        String baseName = this.generateBaseHeaderName();
        return switch ((Integer)this.invalidTypeSelector.next()) {
            case 1 -> this.generateCarriageReturnInjection(baseName);
            case 2 -> this.generateLineFeedInjection(baseName);
            case 3 -> this.generateCRLFInjection(baseName);
            case 4 -> this.generateNullByteInjection(baseName);
            default -> throw new IllegalStateException("Invalid type selector");
        };
    }

    private String generateCarriageReturnInjection(String baseName) {
        return baseName + "\rInjected";
    }

    private String generateLineFeedInjection(String baseName) {
        return baseName + "\nInjected";
    }

    private String generateCRLFInjection(String baseName) {
        return baseName + "\r\nInjected";
    }

    private String generateNullByteInjection(String baseName) {
        return baseName + "\u0000Injected";
    }

    private String generateBaseHeaderName() {
        return switch ((Integer)this.baseHeaderSelector.next()) {
            case 1 -> "Authorization";
            case 2 -> "Content-Type";
            case 3 -> "Accept";
            case 4 -> "User-Agent";
            case 5 -> "Host";
            case 6 -> "Referer";
            case 7 -> "Cookie";
            case 8 -> "X-Custom";
            case 9 -> "Cache-Control";
            default -> "Authorization";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

