/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.header;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class HTTPHeaderInjectionGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> injectionTypeGen = Generators.integers((int)1, (int)8);
    private final TypedGenerator<Integer> baseTokenSelector = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> injectedHeaderSelector = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> maliciousValueSelector = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> maliciousUrlSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> contentTypeSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> hostGeneratorSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> methodSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> pathInjectionSelector = Generators.integers((int)1, (int)4);

    public String next() {
        return switch ((Integer)this.injectionTypeGen.next()) {
            case 1 -> this.generateCrlfInjection();
            case 2 -> this.generateHttpResponseSplitting();
            case 3 -> this.generateNullByteInjection();
            case 4 -> this.generateCookieInjection();
            case 5 -> this.generateSecurityHeaderOverride();
            case 6 -> this.generateContentTypeOverride();
            case 7 -> this.generateHttpRequestSmuggling();
            case 8 -> this.generateHostHeaderInjection();
            default -> this.generateCrlfInjection();
        };
    }

    private String generateCrlfInjection() {
        String baseToken = this.generateBaseToken();
        String injectedHeader = this.generateInjectedHeader();
        String maliciousValue = this.generateMaliciousValue();
        String lineEnding = switch ((Integer)Generators.integers((int)1, (int)3).next()) {
            case 1 -> "\r\n";
            case 2 -> "\n";
            case 3 -> "\r";
            default -> "\r\n";
        };
        return baseToken + lineEnding + injectedHeader + ": " + maliciousValue;
    }

    private String generateHttpResponseSplitting() {
        String baseToken = this.generateBaseToken();
        return baseToken + "\r\n\r\nHTTP/1.1 200 OK";
    }

    private String generateNullByteInjection() {
        String baseToken = this.generateBaseToken();
        return baseToken + "\u0000admin";
    }

    private String generateCookieInjection() {
        String baseToken = this.generateBaseToken();
        String maliciousValue = this.generateMaliciousValue();
        return baseToken + "\r\nSet-Cookie: " + maliciousValue;
    }

    private String generateSecurityHeaderOverride() {
        String baseToken = this.generateBaseToken();
        return switch ((Integer)Generators.integers((int)1, (int)4).next()) {
            case 1 -> baseToken + "\r\nX-Frame-Options: DENY";
            case 2 -> baseToken + "\r\nContent-Security-Policy: none";
            case 3 -> baseToken + "\r\nAccess-Control-Allow-Origin: *";
            case 4 -> baseToken + "\r\nX-XSS-Protection: 0";
            default -> baseToken + "\r\nX-Frame-Options: DENY";
        };
    }

    private String generateContentTypeOverride() {
        String baseToken = this.generateBaseToken();
        String contentType = this.generateContentType();
        return switch ((Integer)Generators.integers((int)1, (int)3).next()) {
            case 1 -> baseToken + "\r\nContent-Type: " + contentType;
            case 2 -> baseToken + "\r\nContent-Length: 0";
            case 3 -> baseToken + "\r\nTransfer-Encoding: chunked";
            default -> baseToken + "\r\nContent-Type: " + contentType;
        };
    }

    private String generateHttpRequestSmuggling() {
        String baseToken = this.generateBaseToken();
        String method = this.generateMethod();
        String path = this.generatePathInjection();
        return baseToken + "\n\n" + method + " " + path + " HTTP/1.1";
    }

    private String generateHostHeaderInjection() {
        String baseToken = this.generateBaseToken();
        String host = this.generateHostHeader();
        return switch ((Integer)Generators.integers((int)1, (int)2).next()) {
            case 1 -> baseToken + "\r\nHost: " + host;
            case 2 -> baseToken + "\r\nLocation: " + this.generateMaliciousUrl();
            default -> baseToken + "\r\nHost: " + host;
        };
    }

    private String generateBaseToken() {
        return switch ((Integer)this.baseTokenSelector.next()) {
            case 1 -> "Bearer token";
            case 2 -> "auth";
            case 3 -> "value";
            case 4 -> "token";
            case 5 -> "session";
            default -> "Bearer token";
        };
    }

    private String generateInjectedHeader() {
        return switch ((Integer)this.injectedHeaderSelector.next()) {
            case 1 -> "X-Injected";
            case 2 -> "X-Forwarded-For";
            case 3 -> "X-Real-IP";
            case 4 -> "X-Admin";
            case 5 -> "Authorization";
            default -> "X-Injected";
        };
    }

    private String generateMaliciousValue() {
        return switch ((Integer)this.maliciousValueSelector.next()) {
            case 1 -> "malicious";
            case 2 -> "evil=value";
            case 3 -> "admin";
            case 4 -> "bypass";
            case 5 -> "attack";
            default -> "malicious";
        };
    }

    private String generateMaliciousUrl() {
        return switch ((Integer)this.maliciousUrlSelector.next()) {
            case 1 -> "http://evil.com";
            case 2 -> "https://attacker.example";
            case 3 -> "//malicious.site";
            case 4 -> "javascript:alert(1)";
            default -> "http://evil.com";
        };
    }

    private String generateContentType() {
        return switch ((Integer)this.contentTypeSelector.next()) {
            case 1 -> "text/html";
            case 2 -> "text/javascript";
            case 3 -> "application/octet-stream";
            case 4 -> "image/svg+xml";
            default -> "text/html";
        };
    }

    private String generateHostHeader() {
        return switch ((Integer)this.hostGeneratorSelector.next()) {
            case 1 -> "evil.example.com";
            case 2 -> "attacker.com";
            case 3 -> "127.0.0.1";
            case 4 -> "localhost";
            default -> "evil.example.com";
        };
    }

    private String generateMethod() {
        return switch ((Integer)this.methodSelector.next()) {
            case 1 -> "GET";
            case 2 -> "POST";
            case 3 -> "PUT";
            case 4 -> "DELETE";
            default -> "GET";
        };
    }

    private String generatePathInjection() {
        return switch ((Integer)this.pathInjectionSelector.next()) {
            case 1 -> "/admin";
            case 2 -> "/api";
            case 3 -> "/config";
            case 4 -> "/users";
            default -> "/admin";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

