/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.encoding;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class UnicodeNormalizationAttackGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> basePatternTypeGen = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> depthGen = Generators.integers((int)2, (int)6);
    private final TypedGenerator<Integer> scriptElementGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> protocolGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> funcGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> attackTypeGen = Generators.integers((int)1, (int)9);

    public String next() {
        String basePattern = this.generateBasePattern();
        int attackType = (Integer)this.attackTypeGen.next();
        return switch (attackType) {
            case 1 -> this.createDecomposedNormalizationAttack(basePattern);
            case 3 -> this.createCompatibilityNormalizationAttack(basePattern);
            case 4 -> this.createCombiningCharacterAttack(basePattern);
            case 5 -> this.createHomographAttack(basePattern);
            case 6 -> this.createOverlongSequenceAttack(basePattern);
            case 7 -> this.createMixedScriptAttack(basePattern);
            case 8 -> this.createZeroWidthInjectionAttack(basePattern);
            case 9 -> this.createBidirectionalOverrideAttack(basePattern);
            default -> this.createComposedNormalizationAttack(basePattern);
        };
    }

    private String generateBasePattern() {
        return switch ((Integer)this.basePatternTypeGen.next()) {
            case 1 -> this.generateTraversalPattern();
            case 2 -> this.generateScriptPattern();
            case 3 -> this.generateProtocolPattern();
            case 4 -> this.generateFunctionPattern();
            case 5 -> this.generateBackslashTraversalPattern();
            default -> "../";
        };
    }

    private String generateTraversalPattern() {
        int depth = (Integer)this.depthGen.next();
        return "../".repeat(depth);
    }

    private String generateScriptPattern() {
        String element = switch ((Integer)this.scriptElementGen.next()) {
            case 2 -> "img";
            case 3 -> "iframe";
            case 4 -> "object";
            default -> "script";
        };
        return "<" + element + ">";
    }

    private String generateProtocolPattern() {
        String protocol = switch ((Integer)this.protocolGen.next()) {
            case 2 -> "data";
            case 3 -> "vbscript";
            case 4 -> "file";
            default -> "javascript";
        };
        return protocol + "://malicious.example.com/";
    }

    private String generateFunctionPattern() {
        String func = switch ((Integer)this.funcGen.next()) {
            case 2 -> "alert";
            case 3 -> "confirm";
            case 4 -> "setTimeout";
            default -> "eval";
        };
        return func + "(document.cookie)";
    }

    private String generateBackslashTraversalPattern() {
        int depth = (Integer)this.depthGen.next();
        return "..\\".repeat(depth);
    }

    private String createDecomposedNormalizationAttack(String pattern) {
        StringBuilder result = new StringBuilder();
        block7: for (char c : pattern.toCharArray()) {
            switch (c) {
                case '.': {
                    result.append('.').append('\u0300');
                    continue block7;
                }
                case '/': {
                    result.append('/').append('\u0301');
                    continue block7;
                }
                case '<': {
                    result.append('<').append('\u0302');
                    continue block7;
                }
                case '>': {
                    result.append('>').append('\u0303');
                    continue block7;
                }
                case '=': {
                    result.append('=').append('\u0304');
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private String createComposedNormalizationAttack(String pattern) {
        Object result = pattern.replace(".", "\u1e00").replace("/", "\u2044").replace("\\", "\u29f5").replace(":", "\uff1a").replace("=", "\uff1d");
        if (((String)result).equals(pattern)) {
            result = "\u2044" + pattern + "\uff1a";
        }
        return result;
    }

    private String createCompatibilityNormalizationAttack(String pattern) {
        StringBuilder result = new StringBuilder();
        block13: for (char c : pattern.toCharArray()) {
            switch (c) {
                case '.': {
                    result.append('\uff0e');
                    continue block13;
                }
                case '/': {
                    result.append('\uff0f');
                    continue block13;
                }
                case '\\': {
                    result.append('\uff3c');
                    continue block13;
                }
                case '<': {
                    result.append('\uff1c');
                    continue block13;
                }
                case '>': {
                    result.append('\uff1e');
                    continue block13;
                }
                case ':': {
                    result.append('\uff1a');
                    continue block13;
                }
                case '=': {
                    result.append('\uff1d');
                    continue block13;
                }
                case 'a': {
                    result.append('\uff41');
                    continue block13;
                }
                case 's': {
                    result.append('\uff53');
                    continue block13;
                }
                case 'd': {
                    result.append('\uff44');
                    continue block13;
                }
                case 't': {
                    result.append('\uff54');
                    continue block13;
                }
                default: {
                    result.append('\uff41');
                }
            }
        }
        return result.toString();
    }

    private String createCombiningCharacterAttack(String pattern) {
        StringBuilder result = new StringBuilder();
        block7: for (char c : pattern.toCharArray()) {
            result.append(c);
            switch (c % 5) {
                case 0: {
                    result.append('\u0300');
                    continue block7;
                }
                case 1: {
                    result.append('\u0301');
                    continue block7;
                }
                case 2: {
                    result.append('\u0302');
                    continue block7;
                }
                case 3: {
                    result.append('\u0303');
                    continue block7;
                }
                case 4: {
                    result.append('\u0304');
                    continue block7;
                }
                default: {
                    result.append('\u0300');
                }
            }
        }
        return result.toString();
    }

    private String createHomographAttack(String pattern) {
        Object result = pattern.replace("a", "\u0430").replace("o", "\u043e").replace("p", "\u0440").replace("c", "\u0441").replace("e", "\u0435").replace("x", "\u0445").replace(".", "\u06d4").replace("/", "\u2215");
        if (((String)result).equals(pattern)) {
            result = "\u0430dmin" + pattern + "\u0440\u043e\u043e\u0442";
        }
        return result;
    }

    private String createOverlongSequenceAttack(String pattern) {
        StringBuilder result = new StringBuilder();
        block5: for (char c : pattern.toCharArray()) {
            switch (c) {
                case '.': {
                    result.append('\u2024');
                    continue block5;
                }
                case '/': {
                    result.append('\u2044');
                    continue block5;
                }
                case '\\': {
                    result.append('\u2216');
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        String resultStr = result.toString();
        if (resultStr.equals(pattern)) {
            result.append('\u2024').append('\u2044');
        }
        return result.toString();
    }

    private String createMixedScriptAttack(String pattern) {
        StringBuilder result = new StringBuilder();
        boolean useCyrillic = false;
        for (char c : pattern.toCharArray()) {
            if (Character.isLetter(c)) {
                if (useCyrillic) {
                    switch (c) {
                        case 'a': {
                            result.append('\u0430');
                            break;
                        }
                        case 'o': {
                            result.append('\u043e');
                            break;
                        }
                        case 'p': {
                            result.append('\u0440');
                            break;
                        }
                        case 'c': {
                            result.append('\u0441');
                            break;
                        }
                        case 'e': {
                            result.append('\u0435');
                            break;
                        }
                        default: {
                            result.append(c);
                            break;
                        }
                    }
                } else {
                    switch (c) {
                        case 'a': {
                            result.append('\u03b1');
                            break;
                        }
                        case 'o': {
                            result.append('\u03bf');
                            break;
                        }
                        case 'p': {
                            result.append('\u03c1');
                            break;
                        }
                        default: {
                            result.append(c);
                        }
                    }
                }
                useCyrillic = !useCyrillic;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String createZeroWidthInjectionAttack(String pattern) {
        StringBuilder result = new StringBuilder();
        block6: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 4) {
                case 0: {
                    result.append('\u200b');
                    continue block6;
                }
                case 1: {
                    result.append('\u200c');
                    continue block6;
                }
                case 2: {
                    result.append('\u200d');
                    continue block6;
                }
                case 3: {
                    result.append('\ufeff');
                    continue block6;
                }
                default: {
                    result.append('\u200b');
                }
            }
        }
        return result.toString();
    }

    private String createBidirectionalOverrideAttack(String pattern) {
        return "\u202e" + pattern + "\u202c\u061cconfig\u200e";
    }

    public Class<String> getType() {
        return String.class;
    }
}

