/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.encoding;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class UnicodeControlCharacterAttackGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> basePatternTypeGen = Generators.integers((int)1, (int)6);
    private final TypedGenerator<Integer> attackTypeGen = Generators.integers((int)1, (int)12);
    private final TypedGenerator<Integer> traversalSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> scriptSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> protocolSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> systemSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> pathSelector = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> commandSelector = Generators.integers((int)1, (int)4);

    public String next() {
        String basePattern = this.generateBasePattern();
        int attackType = (Integer)this.attackTypeGen.next();
        return switch (attackType) {
            case 1 -> this.injectC0ControlCharacters(basePattern);
            case 2 -> this.injectC1ControlCharacters(basePattern);
            case 3 -> this.injectFormatControlCharacters(basePattern);
            case 4 -> this.injectBidirectionalControl(basePattern);
            case 5 -> this.injectZeroWidthCharacters(basePattern);
            case 6 -> this.injectVariationSelectors(basePattern);
            case 7 -> this.injectPrivateUseCharacters(basePattern);
            case 8 -> this.injectSurrogatePairs(basePattern);
            case 9 -> this.injectLineBreakControl(basePattern);
            case 10 -> this.injectUrlControlCharacters(basePattern);
            case 11 -> this.injectMixedControlSequences(basePattern);
            case 12 -> this.injectEncodedControlBypasses(basePattern);
            default -> basePattern;
        };
    }

    private String generateBasePattern() {
        return switch ((Integer)this.basePatternTypeGen.next()) {
            case 1 -> this.generateTraversalPattern();
            case 2 -> this.generateScriptTag();
            case 3 -> this.generateProtocol();
            case 4 -> this.generateSystemTarget();
            case 5 -> this.generateSystemPath();
            case 6 -> this.generateCommand();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(this.basePatternTypeGen.next()));
        };
    }

    private String injectC0ControlCharacters(String pattern) {
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 8) {
                case 0: {
                    result.append('\u0000');
                    continue block10;
                }
                case 1: {
                    result.append('\u0001');
                    continue block10;
                }
                case 2: {
                    result.append('\b');
                    continue block10;
                }
                case 3: {
                    result.append('\t');
                    continue block10;
                }
                case 4: {
                    result.append('\n');
                    continue block10;
                }
                case 5: {
                    result.append('\r');
                    continue block10;
                }
                case 6: {
                    result.append('\u001b');
                    continue block10;
                }
                case 7: {
                    result.append('\u001f');
                    continue block10;
                }
            }
        }
        return result.toString();
    }

    private String injectC1ControlCharacters(String pattern) {
        StringBuilder result = new StringBuilder();
        block8: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 6) {
                case 0: {
                    result.append('\u0080');
                    continue block8;
                }
                case 1: {
                    result.append('\u0081');
                    continue block8;
                }
                case 2: {
                    result.append('\u008d');
                    continue block8;
                }
                case 3: {
                    result.append('\u0090');
                    continue block8;
                }
                case 4: {
                    result.append('\u009c');
                    continue block8;
                }
                case 5: {
                    result.append('\u009f');
                    continue block8;
                }
            }
        }
        return result.toString();
    }

    private String injectFormatControlCharacters(String pattern) {
        StringBuilder result = new StringBuilder();
        block6: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 4) {
                case 0: {
                    result.append('\u2028');
                    continue block6;
                }
                case 1: {
                    result.append('\u2029');
                    continue block6;
                }
                case 2: {
                    result.append('\u00a0');
                    continue block6;
                }
                case 3: {
                    result.append('\u1680');
                    continue block6;
                }
            }
        }
        return result.toString();
    }

    private String injectBidirectionalControl(String pattern) {
        StringBuilder result = new StringBuilder();
        result.append('\u202e');
        block7: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 5) {
                case 0: {
                    result.append('\u202c');
                    continue block7;
                }
                case 1: {
                    result.append('\u202d');
                    continue block7;
                }
                case 2: {
                    result.append('\u200e');
                    continue block7;
                }
                case 3: {
                    result.append('\u200f');
                    continue block7;
                }
                case 4: {
                    result.append('\u061c');
                    continue block7;
                }
            }
        }
        result.append('\u202c');
        return result.toString();
    }

    private String injectZeroWidthCharacters(String pattern) {
        StringBuilder result = new StringBuilder();
        block7: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 5) {
                case 0: {
                    result.append('\u200b');
                    continue block7;
                }
                case 1: {
                    result.append('\u200c');
                    continue block7;
                }
                case 2: {
                    result.append('\u200d');
                    continue block7;
                }
                case 3: {
                    result.append('\ufeff');
                    continue block7;
                }
                case 4: {
                    result.append('\u180e');
                    continue block7;
                }
            }
        }
        return result.toString();
    }

    private String injectVariationSelectors(String pattern) {
        StringBuilder result = new StringBuilder();
        block6: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 4) {
                case 0: {
                    result.append('\ufe00');
                    continue block6;
                }
                case 1: {
                    result.append('\ufe0f');
                    continue block6;
                }
                case 2: {
                    result.append('\u0300');
                    continue block6;
                }
                case 3: {
                    result.append('\u036f');
                    continue block6;
                }
            }
        }
        return result.toString();
    }

    private String injectPrivateUseCharacters(String pattern) {
        StringBuilder result = new StringBuilder();
        block8: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 6) {
                case 0: {
                    result.append('\ue000');
                    continue block8;
                }
                case 1: {
                    result.append('\ue001');
                    continue block8;
                }
                case 2: {
                    result.append('\uf8ff');
                    continue block8;
                }
                case 3: {
                    result.append('\uf000');
                    continue block8;
                }
                case 4: {
                    result.append('\ue100');
                    continue block8;
                }
                case 5: {
                    result.append('\uf900');
                    continue block8;
                }
            }
        }
        return result.toString();
    }

    private String injectSurrogatePairs(String pattern) {
        StringBuilder result = new StringBuilder();
        block5: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 3) {
                case 0: {
                    result.append('\ud800');
                    continue block5;
                }
                case 1: {
                    result.append('\udc00');
                    continue block5;
                }
                case 2: {
                    result.append('\udc00').append('\ud800');
                    continue block5;
                }
            }
        }
        return result.toString();
    }

    private String injectLineBreakControl(String pattern) {
        StringBuilder result = new StringBuilder();
        block9: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 7) {
                case 0: {
                    result.append('\n');
                    continue block9;
                }
                case 1: {
                    result.append('\r');
                    continue block9;
                }
                case 2: {
                    result.append('\u0085');
                    continue block9;
                }
                case 3: {
                    result.append('\u2028');
                    continue block9;
                }
                case 4: {
                    result.append('\u2029');
                    continue block9;
                }
                case 5: {
                    result.append('\u000b');
                    continue block9;
                }
                case 6: {
                    result.append('\f');
                    continue block9;
                }
            }
        }
        return result.toString();
    }

    private String injectUrlControlCharacters(String pattern) {
        StringBuilder result = new StringBuilder();
        result.append("http").append('\u0000').append("://");
        result.append("evil").append('\u200b').append("site.com");
        result.append('\u202e').append("/").append('\u202c');
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            if (i % 3 == 0) {
                result.append('\u2028');
            }
            if (i % 4 != 0) continue;
            result.append('\u0000');
        }
        return result.toString();
    }

    private String injectMixedControlSequences(String pattern) {
        StringBuilder result = new StringBuilder();
        result.append('\u202e');
        block12: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 10) {
                case 0: {
                    result.append('\u0000');
                    continue block12;
                }
                case 1: {
                    result.append('\u200b');
                    continue block12;
                }
                case 2: {
                    result.append('\u0080');
                    continue block12;
                }
                case 3: {
                    result.append('\u2028');
                    continue block12;
                }
                case 4: {
                    result.append('\ufe00');
                    continue block12;
                }
                case 5: {
                    result.append('\ue000');
                    continue block12;
                }
                case 6: {
                    result.append('\u001b');
                    continue block12;
                }
                case 7: {
                    result.append('\u202c');
                    continue block12;
                }
                case 8: {
                    result.append('\ud800');
                    continue block12;
                }
                case 9: {
                    result.append('\u0300');
                    continue block12;
                }
            }
        }
        result.append('\u202c');
        return result.toString();
    }

    private String injectEncodedControlBypasses(String pattern) {
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            result.append(c);
            switch (i % 8) {
                case 0: {
                    result.append("%00");
                    continue block10;
                }
                case 1: {
                    result.append("%01");
                    continue block10;
                }
                case 2: {
                    result.append("%08");
                    continue block10;
                }
                case 3: {
                    result.append("%0A");
                    continue block10;
                }
                case 4: {
                    result.append("%0D");
                    continue block10;
                }
                case 5: {
                    result.append("%1B");
                    continue block10;
                }
                case 6: {
                    result.append("%7F");
                    continue block10;
                }
                case 7: {
                    result.append("%C2%80");
                    continue block10;
                }
            }
        }
        return result.toString();
    }

    public boolean containsControlCharacters(String input) {
        if (input == null) {
            return false;
        }
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isISOControl(c) && !this.isC1Control(c) && !this.isFormatControl(c) && !this.isZeroWidth(c) && !this.isBidirectionalControl(c)) continue;
            return true;
        }
        return false;
    }

    private boolean isC1Control(char c) {
        return c >= '\u0080' && c <= '\u009f';
    }

    private boolean isFormatControl(char c) {
        return c == '\u2028' || c == '\u2029' || c == '\u00a0' || c == '\u1680';
    }

    private boolean isZeroWidth(char c) {
        return c == '\u200b' || c == '\u200c' || c == '\u200d' || c == '\ufeff' || c == '\u180e';
    }

    private boolean isBidirectionalControl(char c) {
        return c == '\u202c' || c == '\u202d' || c == '\u202e' || c == '\u200e' || c == '\u200f' || c == '\u061c';
    }

    private String generateTraversalPattern() {
        return switch ((Integer)this.traversalSelector.next()) {
            case 2 -> "..\\";
            case 3 -> "../../";
            case 4 -> "../../../";
            default -> "../";
        };
    }

    private String generateScriptTag() {
        return switch ((Integer)this.scriptSelector.next()) {
            case 2 -> "<iframe>";
            case 3 -> "<img>";
            case 4 -> "<svg>";
            default -> "<script>";
        };
    }

    private String generateProtocol() {
        return switch ((Integer)this.protocolSelector.next()) {
            case 2 -> "data:";
            case 3 -> "file:";
            case 4 -> "vbscript:";
            default -> "javascript:";
        };
    }

    private String generateSystemTarget() {
        return switch ((Integer)this.systemSelector.next()) {
            case 2 -> "root";
            case 3 -> "config";
            case 4 -> "system";
            default -> "admin";
        };
    }

    private String generateSystemPath() {
        return switch ((Integer)this.pathSelector.next()) {
            case 2 -> "/windows/system32";
            case 3 -> "/proc/self";
            case 4 -> "/var/log";
            default -> "/etc/passwd";
        };
    }

    private String generateCommand() {
        return switch ((Integer)this.commandSelector.next()) {
            case 2 -> "shell";
            case 3 -> "bash";
            case 4 -> "powershell";
            default -> "cmd.exe";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

