/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.encoding;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class PathTraversalGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> depthGenerator = Generators.integers((int)1, (int)8);
    private final TypedGenerator<Integer> attackTypeGenerator = Generators.integers((int)0, (int)6);
    private final TypedGenerator<Boolean> contextSelector = Generators.booleans();

    public String next() {
        String pattern;
        int attackType = (Integer)this.attackTypeGenerator.next();
        switch (attackType) {
            case 1: {
                String string = this.generateEncodedTraversal();
                break;
            }
            case 2: {
                String string = this.generateDoubleEncodedTraversal();
                break;
            }
            case 3: {
                String string = this.generateUnicodeTraversal();
                break;
            }
            case 4: {
                String string = this.generateMixedEncodingTraversal();
                break;
            }
            case 5: {
                String string = this.generateNullByteTraversal();
                break;
            }
            case 6: {
                String string = this.generateAdvancedTraversal();
                break;
            }
            default: {
                String string = pattern = this.generateBasicTraversal();
            }
        }
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            return this.addRandomContext(pattern);
        }
        return pattern;
    }

    private String generateBasicTraversal() {
        int depth = (Integer)this.depthGenerator.next();
        String separator = this.generateSeparator();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("..").append(separator);
        }
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            pattern.append(this.generateTargetFile());
        }
        return pattern.toString();
    }

    private String generateSeparator() {
        int sepType = (Integer)Generators.integers((int)0, (int)1).next();
        return sepType == 1 ? "\\" : "/";
    }

    private String generateTargetFile() {
        int fileType = (Integer)Generators.integers((int)0, (int)6).next();
        return switch (fileType) {
            case 1 -> "windows/win.ini";
            case 2 -> "boot.ini";
            case 3 -> "etc/shadow";
            case 4 -> "etc/hosts";
            case 5 -> "windows/system32/config/sam";
            case 6 -> "proc/self/environ";
            default -> "etc/passwd";
        };
    }

    private String generateFileExtension() {
        int extType = (Integer)Generators.integers((int)0, (int)7).next();
        return switch (extType) {
            case 0 -> "jpg";
            case 1 -> "exe";
            case 2 -> "png";
            case 3 -> "gif";
            case 5 -> "php";
            case 6 -> "jsp";
            case 7 -> "asp";
            default -> "txt";
        };
    }

    private String generatePrefix() {
        int prefixType = (Integer)Generators.integers((int)0, (int)6).next();
        return switch (prefixType) {
            case 1 -> "/admin/";
            case 2 -> "/files/";
            case 3 -> "/uploads/";
            case 4 -> "/documents/";
            case 5 -> "/images/";
            case 6 -> "";
            default -> "/api/users/";
        };
    }

    private String generateSuffix() {
        int suffixType = (Integer)Generators.integers((int)0, (int)5).next();
        return switch (suffixType) {
            case 1 -> "/config.xml";
            case 2 -> ".php";
            case 3 -> ".jsp";
            case 4 -> ".asp";
            case 5 -> "";
            default -> "/sensitive.txt";
        };
    }

    private String generateEncodedTraversal() {
        int depth = (Integer)this.depthGenerator.next();
        boolean useBackslash = "\\".equals(this.generateSeparator());
        StringBuilder pattern = new StringBuilder();
        String dotEncoded = "%2e";
        String separatorEncoded = useBackslash ? "%5c" : "%2f";
        for (int i = 0; i < depth; ++i) {
            pattern.append(dotEncoded).append(dotEncoded).append(separatorEncoded);
        }
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            String target = this.generateTargetFile().replace("/", separatorEncoded).replace("\\", "%5c");
            pattern.append(target);
        }
        return pattern.toString();
    }

    private String generateDoubleEncodedTraversal() {
        int depth = (Integer)this.depthGenerator.next();
        boolean useBackslash = "\\".equals(this.generateSeparator());
        StringBuilder pattern = new StringBuilder();
        String dotEncoded = "%252e";
        String separatorEncoded = useBackslash ? "%255c" : "%252f";
        for (int i = 0; i < depth; ++i) {
            pattern.append(dotEncoded).append(dotEncoded).append(separatorEncoded);
        }
        return pattern.toString();
    }

    private String generateUnicodeTraversal() {
        int depth = (Integer)this.depthGenerator.next();
        boolean useBackslash = "\\".equals(this.generateSeparator());
        StringBuilder pattern = new StringBuilder();
        String dotUnicode = "\\u002e";
        String separatorUnicode = useBackslash ? "\\u005c" : "\\u002f";
        for (int i = 0; i < depth; ++i) {
            pattern.append(dotUnicode).append(dotUnicode).append(separatorUnicode);
        }
        return pattern.toString();
    }

    private String generateMixedEncodingTraversal() {
        int depth = (Integer)this.depthGenerator.next();
        String separator = this.generateSeparator();
        StringBuilder pattern = new StringBuilder();
        block5: for (int i = 0; i < depth; ++i) {
            int encodingChoice = (Integer)Generators.integers((int)0, (int)3).next();
            switch (encodingChoice) {
                case 1: {
                    pattern.append("%2e%2e").append(separator);
                    continue block5;
                }
                case 2: {
                    pattern.append("\\u002e\\u002e").append(separator);
                    continue block5;
                }
                case 3: {
                    pattern.append("%2e%2e").append("/".equals(separator) ? "%2f" : "%5c");
                    continue block5;
                }
                default: {
                    pattern.append("..").append(separator);
                }
            }
        }
        return pattern.toString();
    }

    private String generateNullByteTraversal() {
        String basePattern = this.generateBasicTraversal();
        int nullBytePosition = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (nullBytePosition) {
            case 1 -> basePattern + "%00." + this.generateFileExtension();
            case 2 -> basePattern.replace("..", "..%00");
            case 3 -> basePattern + this.generateTargetFile() + "%00." + this.generateFileExtension();
            default -> basePattern + "%00";
        };
    }

    private String generateAdvancedTraversal() {
        int depth = (Integer)this.depthGenerator.next();
        String separator = this.generateSeparator();
        StringBuilder pattern = new StringBuilder();
        int advancedType = (Integer)Generators.integers((int)0, (int)4).next();
        switch (advancedType) {
            case 0: {
                for (int i = 0; i < depth; ++i) {
                    pattern.append("....").append(separator).append(separator);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < depth; ++i) {
                    pattern.append("..").append("/").append("..").append("\\");
                }
                break;
            }
            case 2: {
                pattern.append("%c0%ae%c0%ae%c0%af".repeat(Math.max(0, depth)));
                break;
            }
            case 3: {
                pattern.append((Boolean)this.contextSelector.next() != false ? "/var/www/" : "C:\\inetpub\\wwwroot\\");
                pattern.append(this.generateBasicTraversal());
                break;
            }
            case 4: {
                pattern.append("\\ufe0e\\ufe0e\\u2044".repeat(Math.max(0, depth)));
                break;
            }
            default: {
                pattern.append(this.generateBasicTraversal());
            }
        }
        return pattern.toString();
    }

    private String addRandomContext(String basePattern) {
        String prefix = this.generatePrefix();
        String suffix = this.generateSuffix();
        return prefix + basePattern + suffix;
    }

    public Class<String> getType() {
        return String.class;
    }
}

