/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.encoding;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import java.util.regex.Pattern;

public class EncodingCombinationGenerator
implements TypedGenerator<String> {
    private static final Pattern LOWERCASE_2E_PATTERN = Pattern.compile("%2e");
    private static final Pattern LOWERCASE_2F_PATTERN = Pattern.compile("%2f");
    private final TypedGenerator<Integer> basePatternTypeGen = Generators.integers((int)1, (int)5);
    private final TypedGenerator<Integer> depthGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Boolean> useBackslashGen = Generators.booleans();
    private final TypedGenerator<Integer> encodingLevelGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Boolean> mixedCaseGen = Generators.booleans();

    public String next() {
        String basePattern = this.generateBasePattern();
        int level = (Integer)this.encodingLevelGen.next();
        boolean mixedCase = (Boolean)this.mixedCaseGen.next();
        String encoded = basePattern;
        for (int i = 0; i < level; ++i) {
            encoded = this.urlEncode(encoded);
        }
        if (mixedCase) {
            encoded = this.applyMixedCase(encoded);
        }
        return encoded;
    }

    private String generateBasePattern() {
        return switch ((Integer)this.basePatternTypeGen.next()) {
            case 1 -> this.generateSimpleTraversal();
            case 2 -> this.generateWindowsTraversal();
            case 3 -> this.generateDeepTraversal();
            case 4 -> this.generateMixedSeparatorTraversal();
            case 5 -> this.generateCustomDepthTraversal();
            default -> this.generateSimpleTraversal();
        };
    }

    private String generateSimpleTraversal() {
        return (Boolean)this.useBackslashGen.next() != false ? "..\\" : "../";
    }

    private String generateWindowsTraversal() {
        return "..\\";
    }

    private String generateDeepTraversal() {
        int depth = (Integer)this.depthGen.next();
        String separator = (Boolean)this.useBackslashGen.next() != false ? "\\" : "/";
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("..").append(separator);
        }
        return pattern.toString();
    }

    private String generateMixedSeparatorTraversal() {
        return "../..\\../";
    }

    private String generateCustomDepthTraversal() {
        int customDepth = (Integer)Generators.integers((int)2, (int)6).next();
        String separator = (Boolean)this.useBackslashGen.next() != false ? "\\" : "/";
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < customDepth; ++i) {
            pattern.append("..").append(separator);
        }
        return pattern.toString();
    }

    private String urlEncode(String input) {
        return input.replace(".", "%2e").replace("/", "%2f").replace("%", "%25");
    }

    private String applyMixedCase(String input) {
        String result = LOWERCASE_2E_PATTERN.matcher(input).replaceAll("%2E");
        return LOWERCASE_2F_PATTERN.matcher(result).replaceAll("%2F");
    }

    public Class<String> getType() {
        return String.class;
    }
}

