/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.encoding;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class DoubleEncodingAttackGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> encodingTypeGen = Generators.integers((int)1, (int)8);
    private final TypedGenerator<Integer> depthGen = Generators.integers((int)1, (int)6);
    private final TypedGenerator<Integer> pathPrefixSelector = Generators.integers((int)1, (int)6);
    private final TypedGenerator<Integer> targetFileSelector = Generators.integers((int)1, (int)6);

    public String next() {
        int encodingType = (Integer)this.encodingTypeGen.next();
        return switch (encodingType) {
            case 1 -> this.generateClassicDoubleEncoding();
            case 2 -> this.generateApacheCVEDoubleEncoding();
            case 3 -> this.generateMixedSingleDoubleEncoding();
            case 4 -> this.generateTripleEncoding();
            case 5 -> this.generateCaseVariationDoubleEncoding();
            case 6 -> this.generateWindowsDoubleEncoding();
            case 7 -> this.generateLegitimatePathDoubleEncoding();
            case 8 -> this.generateDeepDoubleEncoding();
            default -> this.generateClassicDoubleEncoding();
        };
    }

    private String generateClassicDoubleEncoding() {
        int depth = (Integer)this.depthGen.next();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("%252e%252e%252f");
        }
        if (((Boolean)Generators.booleans().next()).booleanValue()) {
            pattern.append("etc/").append(this.generateTargetFile());
        }
        return pattern.toString();
    }

    private String generateApacheCVEDoubleEncoding() {
        String[] cvePatterns = new String[]{"%%32%65", "%%32%66", "/icons%%32%65%%32%65/etc/" + this.generateTargetFile(), "/cgi-bin/.%%32%65/%%32%65%%32%65/etc/" + this.generateTargetFile()};
        return cvePatterns[(Integer)Generators.integers((int)0, (int)3).next()];
    }

    private String generateMixedSingleDoubleEncoding() {
        String target = this.generateTargetFile();
        return (Boolean)Generators.booleans().next() != false ? "%2e%252e%2f../etc/" + target : "%252e%2e%252f%2e%2e/etc/" + target;
    }

    private String generateTripleEncoding() {
        return (Boolean)Generators.booleans().next() != false ? "%25252e%25252e%25252f" : "%252525%252e%252525%2e%252525%2f";
    }

    private String generateCaseVariationDoubleEncoding() {
        return (Boolean)Generators.booleans().next() != false ? "%252E%252E%252F" : "%252e%252E%252f%252F";
    }

    private String generateWindowsDoubleEncoding() {
        int depth = (Integer)this.depthGen.next();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("%255c%252e%252e");
        }
        pattern.append("%255c");
        if (((Boolean)Generators.booleans().next()).booleanValue()) {
            pattern.append(this.generateTargetFile());
        }
        return pattern.toString();
    }

    private String generateLegitimatePathDoubleEncoding() {
        String prefix = this.generatePathPrefix();
        return "/" + prefix + "%252e%252e%252f%252e%252e%252f" + this.generateTargetFile();
    }

    private String generateDeepDoubleEncoding() {
        int depth = (Integer)this.depthGen.next() + 2;
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("%252e%252e%252f");
        }
        return pattern.toString();
    }

    private String generatePathPrefix() {
        return switch ((Integer)this.pathPrefixSelector.next()) {
            case 1 -> "api";
            case 2 -> "admin";
            case 3 -> "files";
            case 4 -> "config";
            case 5 -> "upload";
            case 6 -> "backup";
            default -> "api";
        };
    }

    private String generateTargetFile() {
        return switch ((Integer)this.targetFileSelector.next()) {
            case 1 -> "passwd";
            case 2 -> "shadow";
            case 3 -> "config";
            case 4 -> "cmd.exe";
            case 5 -> "win.ini";
            case 6 -> "hosts";
            default -> "passwd";
        };
    }

    public Class<String> getType() {
        return String.class;
    }
}

