/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.encoding;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class BoundaryFuzzingGenerator
implements TypedGenerator<String> {
    private final TypedGenerator<Integer> lengthGen = Generators.integers((int)1000, (int)10000);
    private final TypedGenerator<Integer> nestingGen = Generators.integers((int)50, (int)200);
    private final TypedGenerator<Integer> typeGen = Generators.integers((int)0, (int)5);

    public String next() {
        int type = (Integer)this.typeGen.next();
        return switch (type) {
            case 0 -> this.generateLongPath();
            case 1 -> this.generateDeepNesting();
            case 2 -> this.generateNullBytes();
            case 3 -> this.generateControlCharacters();
            case 4 -> this.generateMixedBoundaryAttacks();
            default -> this.generateSpecialChars();
        };
    }

    private String generateLongPath() {
        int length = (Integer)this.lengthGen.next();
        StringBuilder path = new StringBuilder("/");
        while (path.length() < length) {
            path.append("verylongpathsegment/");
        }
        return path.toString();
    }

    private String generateDeepNesting() {
        int depth = (Integer)this.nestingGen.next();
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            path.append("dir/");
        }
        return path.toString();
    }

    private String generateNullBytes() {
        int patternType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (patternType) {
            case 0 -> "/file\u0000.txt";
            case 1 -> "/admin%00.php";
            case 2 -> "../etc/passwd%00.jpg";
            case 3 -> "file.jsp%00.png";
            case 4 -> "%00../../etc/shadow";
            default -> "/file\u0000.txt";
        };
    }

    private String generateControlCharacters() {
        int controlType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (controlType) {
            case 0 -> "/file\r\n.txt";
            case 1 -> "/path\t\tfile";
            case 2 -> "/dir\b\bfile";
            case 3 -> "/test\u001ffile";
            default -> "/file\r\n.txt";
        };
    }

    private String generateMixedBoundaryAttacks() {
        TypedGenerator attackGen = Generators.integers((int)0, (int)3);
        int attack = (Integer)attackGen.next();
        return switch (attack) {
            case 0 -> this.generateTraversalPattern() + "etc/passwd";
            case 1 -> "/a" + this.generatePathSegmentPattern();
            case 2 -> "/%00" + this.generateTraversalPattern();
            default -> "/\u0000/../\u0000/../file";
        };
    }

    private String generateSpecialChars() {
        int specialType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (specialType) {
            case 0 -> "/file|command";
            case 1 -> "/file;command";
            case 2 -> "/file`command`";
            case 3 -> "/file$variable";
            case 4 -> "/file>output";
            default -> "/file|command";
        };
    }

    private String generateTraversalPattern() {
        int depth = (Integer)Generators.integers((int)15, (int)25).next();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("../");
        }
        return pattern.toString();
    }

    private String generatePathSegmentPattern() {
        int segments = (Integer)Generators.integers((int)50, (int)80).next();
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < segments; ++i) {
            pattern.append("verylongpathsegment/");
        }
        return pattern.toString();
    }

    public Class<String> getType() {
        return String.class;
    }
}

