/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.cookie;

import de.cuioss.http.security.data.Cookie;
import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class ValidCookieGenerator
implements TypedGenerator<Cookie> {
    private final TypedGenerator<Integer> cookieTypeGenerator = Generators.integers((int)0, (int)3);
    private final TypedGenerator<Integer> sessionTypeGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> tokenTypeGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> contextTypeGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Integer> domainTypeGen = Generators.integers((int)1, (int)3);
    private final TypedGenerator<Integer> pathTypeGen = Generators.integers((int)1, (int)4);
    private final TypedGenerator<Boolean> contextSelector = Generators.booleans();
    private final TypedGenerator<Integer> numberValues = Generators.integers((int)10000, (int)99999);

    public Cookie next() {
        int type = (Integer)this.cookieTypeGenerator.next();
        String name = switch (type) {
            case 0 -> this.generateSessionName();
            case 1 -> this.generateTokenName();
            case 2 -> this.generatePreferenceName();
            case 3 -> this.generateContextName();
            default -> this.generateSessionName();
        };
        String value = this.generateLegitimateValue();
        String attributes = this.generateValidAttributes();
        return new Cookie(name, value, attributes);
    }

    private String generateSessionName() {
        int nameType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (nameType) {
            case 0 -> "JSESSIONID";
            case 1 -> "session_id";
            case 2 -> this.generateSessionCategory() + "ID";
            case 3 -> this.generateSessionCategory() + "_" + this.generateTokenCategory();
            default -> "JSESSIONID";
        };
    }

    private String generateSessionCategory() {
        return switch ((Integer)this.sessionTypeGen.next()) {
            case 1 -> "JSESSION";
            case 2 -> "session";
            case 3 -> "auth";
            case 4 -> "csrf";
            default -> "session";
        };
    }

    private String generateTokenCategory() {
        return switch ((Integer)this.tokenTypeGen.next()) {
            case 1 -> "token";
            case 2 -> "id";
            case 3 -> "key";
            case 4 -> "hash";
            default -> "token";
        };
    }

    private String generateTokenName() {
        int nameType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (nameType) {
            case 0 -> "auth_token";
            case 1 -> "csrf_token";
            case 2 -> "user_id";
            case 3 -> this.generateContextCategory() + "_" + this.generateTokenCategory();
            case 4 -> this.generateSessionCategory() + "_" + this.generateTokenCategory();
            default -> "auth_token";
        };
    }

    private String generateContextCategory() {
        return switch ((Integer)this.contextTypeGen.next()) {
            case 1 -> "user";
            case 2 -> "cart";
            case 3 -> "device";
            case 4 -> "track";
            default -> "user";
        };
    }

    private String generatePreferenceName() {
        int prefType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (prefType) {
            case 0 -> "language";
            case 1 -> "theme";
            case 2 -> "preferences";
            case 3 -> "settings";
            default -> "language";
        };
    }

    private String generateContextName() {
        String context = this.generateContextCategory();
        String suffix = this.generateDataSuffix();
        return context + "_" + suffix;
    }

    private String generateDataSuffix() {
        int suffixType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (suffixType) {
            case 0 -> "id";
            case 1 -> "data";
            case 2 -> "info";
            case 3 -> "state";
            default -> "id";
        };
    }

    private String generateLegitimateValue() {
        int valueType = (Integer)Generators.integers((int)0, (int)6).next();
        return switch (valueType) {
            case 0 -> this.generateSessionValue();
            case 1 -> this.generateBooleanValue();
            case 2 -> this.generateLocaleValue();
            case 3 -> this.generateThemeValue();
            case 4 -> this.generateAlphanumericValue();
            case 5 -> this.generateTokenValue();
            case 6 -> this.generateContextValue();
            default -> this.generateSessionValue();
        };
    }

    private String generateSessionValue() {
        String prefix = this.generateContextCategory();
        int number = (Integer)this.numberValues.next();
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            return "session_" + number;
        }
        return prefix + "_" + number;
    }

    private String generateBooleanValue() {
        int boolType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (boolType) {
            case 0 -> "true";
            case 1 -> "false";
            case 2 -> "yes";
            case 3 -> "no";
            default -> "true";
        };
    }

    private String generateLocaleValue() {
        int localeType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (localeType) {
            case 0 -> "en_US";
            case 1 -> this.generateLanguage() + "_" + this.generateCountry();
            case 2 -> "de_DE";
            case 3 -> "fr_FR";
            case 4 -> "es_ES";
            default -> "en_US";
        };
    }

    private String generateLanguage() {
        int langType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (langType) {
            case 0 -> "en";
            case 1 -> "de";
            case 2 -> "fr";
            case 3 -> "es";
            case 4 -> "ja";
            default -> "en";
        };
    }

    private String generateCountry() {
        int countryType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (countryType) {
            case 0 -> "US";
            case 1 -> "DE";
            case 2 -> "FR";
            case 3 -> "ES";
            case 4 -> "JP";
            default -> "US";
        };
    }

    private String generateThemeValue() {
        int themeType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (themeType) {
            case 0 -> "dark";
            case 1 -> "light";
            case 2 -> "blue";
            case 3 -> "green";
            default -> "dark";
        };
    }

    private String generateAlphanumericValue() {
        int length = (Integer)Generators.integers((int)8, (int)16).next();
        return ((String)Generators.letterStrings((int)length, (int)(length + 4)).next()).toUpperCase();
    }

    private String generateTokenValue() {
        int prefixType = (Integer)Generators.integers((int)0, (int)2).next();
        String prefix = switch (prefixType) {
            case 0 -> "token";
            case 1 -> "device";
            case 2 -> "remember";
            default -> "token";
        };
        int statusType = (Integer)Generators.integers((int)0, (int)2).next();
        String status = switch (statusType) {
            case 0 -> "valid";
            case 1 -> "active";
            case 2 -> "yes";
            default -> "valid";
        };
        return prefix + "_" + status;
    }

    private String generateContextValue() {
        String context = this.generateContextCategory();
        String suffix = ((String)Generators.letterStrings((int)6, (int)10).next()).toLowerCase();
        return context + "_" + suffix;
    }

    private String generateValidAttributes() {
        int attributeType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (attributeType) {
            case 0 -> "";
            case 1 -> this.generateSingleValidAttribute();
            case 2 -> this.generateMultipleValidAttributes();
            case 3 -> this.generateSecureAttributes();
            default -> "";
        };
    }

    private String generateSingleValidAttribute() {
        int attrType = (Integer)Generators.integers((int)0, (int)6).next();
        return switch (attrType) {
            case 0 -> "Domain=" + this.generateLegitimateDomain();
            case 1 -> "Path=" + this.generateLegitimatePath();
            case 2 -> "Secure";
            case 3 -> "HttpOnly";
            case 4 -> "SameSite=" + this.generateSameSite();
            case 5 -> "Max-Age=" + String.valueOf(Generators.integers((int)60, (int)86400).next());
            case 6 -> "Expires=" + this.generateExpires();
            default -> "Domain=" + this.generateLegitimateDomain();
        };
    }

    private String generateLegitimateDomain() {
        int domainType = (Integer)Generators.integers((int)0, (int)2).next();
        return switch (domainType) {
            case 0 -> this.generateDomainCategory() + ".com";
            case 1 -> this.generateDomainCategory() + ".org";
            case 2 -> this.generateDomainCategory() + ".net";
            default -> "example.com";
        };
    }

    private String generateDomainCategory() {
        return switch ((Integer)this.domainTypeGen.next()) {
            case 1 -> "example";
            case 2 -> "test";
            case 3 -> "demo";
            default -> "example";
        };
    }

    private String generateLegitimatePath() {
        int pathType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (pathType) {
            case 0 -> "/";
            case 1 -> "/" + this.generatePathCategory();
            case 2 -> "/" + this.generatePathCategory() + "/" + this.generatePathCategory();
            case 3 -> "/" + this.generatePathCategory() + "/files";
            case 4 -> "/" + this.generatePathCategory() + "/data";
            default -> "/";
        };
    }

    private String generatePathCategory() {
        return switch ((Integer)this.pathTypeGen.next()) {
            case 1 -> "admin";
            case 2 -> "api";
            case 3 -> "user";
            case 4 -> "files";
            default -> "admin";
        };
    }

    private String generateSameSite() {
        int siteType = (Integer)Generators.integers((int)0, (int)2).next();
        return switch (siteType) {
            case 0 -> "Strict";
            case 1 -> "Lax";
            case 2 -> "None";
            default -> "Lax";
        };
    }

    private String generateExpires() {
        int expiresType = (Integer)Generators.integers((int)0, (int)1).next();
        return switch (expiresType) {
            case 0 -> "Thu, 01 Jan 1970";
            case 1 -> "Fri, 31 Dec 2999";
            default -> "Thu, 01 Jan 1970";
        };
    }

    private String generateMultipleValidAttributes() {
        StringBuilder attrs = new StringBuilder();
        String domain = "Domain=" + this.generateLegitimateDomain();
        String path = "Path=" + this.generateLegitimatePath();
        attrs.append(domain).append("; ").append(path);
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            attrs.append("; Secure");
        }
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            attrs.append("; HttpOnly");
        }
        if (((Boolean)this.contextSelector.next()).booleanValue()) {
            attrs.append("; SameSite=").append(this.generateSameSite());
        }
        return attrs.toString();
    }

    private String generateSecureAttributes() {
        return "Domain=" + this.generateLegitimateDomain() + "; Path=/; Secure; HttpOnly; SameSite=Strict";
    }

    public Class<Cookie> getType() {
        return Cookie.class;
    }
}

