/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.database;

import de.cuioss.http.security.database.LegitimatePatternDatabase;
import de.cuioss.http.security.database.LegitimateTestCase;
import java.util.List;

public class LegitimateSpecialCharactersDatabase
implements LegitimatePatternDatabase {
    public static final LegitimateTestCase HYPHEN_UNDERSCORE = new LegitimateTestCase("/api/user-profile_v2", "Path with hyphens and underscores (RFC 3986 unreserved)", "Hyphens and underscores are explicitly allowed as unreserved characters in RFC 3986");
    public static final LegitimateTestCase TILDE_PATH = new LegitimateTestCase("/~username/public", "Unix-style user directory with tilde", "Tilde is an unreserved character commonly used for user directories");
    public static final LegitimateTestCase DOT_NOTATION = new LegitimateTestCase("/api/v2.1/users", "Version number with dot notation", "Dots are unreserved characters commonly used in version numbers");
    public static final LegitimateTestCase ENCODED_PLUS = new LegitimateTestCase("/search/c%2B%2B", "Search for 'C++' with encoded plus signs", "Plus signs must be encoded as %2B in paths, representing legitimate search terms");
    public static final LegitimateTestCase ENCODED_AMPERSAND = new LegitimateTestCase("/companies/johnson%26johnson", "Company name with encoded ampersand", "Ampersands in company names must be encoded as %26");
    public static final LegitimateTestCase ENCODED_EQUALS = new LegitimateTestCase("/formula/e%3Dmc2", "Scientific formula with encoded equals sign", "Equals signs in paths must be encoded as %3D for formulas and equations");
    public static final LegitimateTestCase FRENCH_ACCENTS = new LegitimateTestCase("/ville/montr%C3%A9al", "French city name 'Montr\u00e9al' with encoded accent", "UTF-8 encoded accented characters (%C3%A9 for \u00e9) are legitimate for internationalization");
    public static final LegitimateTestCase GERMAN_UMLAUT = new LegitimateTestCase("/stadt/m%C3%BCnchen", "German city name 'M\u00fcnchen' with encoded umlaut", "UTF-8 encoded umlauts (%C3%BC for \u00fc) are required for German language support");
    public static final LegitimateTestCase SPANISH_TILDE = new LegitimateTestCase("/a\u00f1o/2024", "Spanish word 'a\u00f1o' (year) with encoded \u00f1", "Spanish \u00f1 character properly encoded for language support");
    public static final LegitimateTestCase JAPANESE_HIRAGANA = new LegitimateTestCase("/search/%E3%81%93%E3%82%93%E3%81%AB%E3%81%A1%E3%81%AF", "Japanese '\u3053\u3093\u306b\u3061\u306f' (hello) in UTF-8 encoding", "Japanese characters must be UTF-8 encoded and accepted for CJK support");
    public static final LegitimateTestCase MATH_OPERATORS = new LegitimateTestCase("/calc/5%2B3%2A2", "Mathematical expression '5+3*2' with encoded operators", "Mathematical operators properly encoded for calculator applications");
    public static final LegitimateTestCase CHEMICAL_FORMULA = new LegitimateTestCase("/molecule/H2O", "Chemical formula with numbers", "Chemical formulas with mixed alphanumeric characters are legitimate");
    public static final LegitimateTestCase COORDINATES = new LegitimateTestCase("/location/40.7128,-74.0060", "GPS coordinates with comma and negative sign", "Geographic coordinates with decimal points and negative signs are valid");
    public static final LegitimateTestCase EMAIL_LIKE_ID = new LegitimateTestCase("/user/john.doe%40example.com", "User identifier resembling email format", "Email-like identifiers with encoded @ symbol (%40) are common in REST APIs");
    public static final LegitimateTestCase PHONE_NUMBER = new LegitimateTestCase("/contact/%2B1-555-123-4567", "International phone number with encoded plus", "Phone numbers with country codes require encoded plus signs");
    public static final LegitimateTestCase SKU_WITH_SLASH = new LegitimateTestCase("/product/ABC%2F123%2FXL", "Product SKU 'ABC/123/XL' with encoded slashes", "SKUs often contain slashes that must be encoded as %2F");
    public static final LegitimateTestCase CURRENCY_SYMBOL = new LegitimateTestCase("/price/%2410.99", "Price with encoded dollar sign", "Currency symbols like $ must be encoded as %24 in paths");
    public static final LegitimateTestCase PERCENTAGE = new LegitimateTestCase("/discount/25%25off", "Discount '25%off' with encoded percent sign", "Percent signs must be encoded as %25 to avoid confusion with encoding");
    public static final LegitimateTestCase PARENTHESES = new LegitimateTestCase("/section/(draft)", "Section marked as draft with parentheses", "Parentheses are valid in paths for annotations and grouping");
    public static final LegitimateTestCase ENCODED_BRACKETS = new LegitimateTestCase("/array/items%5B0%5D", "Array notation with encoded brackets", "Square brackets must be encoded as %5B and %5D in URL paths");
    private static final List<LegitimateTestCase> ALL_LEGITIMATE_TEST_CASES = List.of(HYPHEN_UNDERSCORE, TILDE_PATH, DOT_NOTATION, ENCODED_PLUS, ENCODED_AMPERSAND, ENCODED_EQUALS, FRENCH_ACCENTS, GERMAN_UMLAUT, SPANISH_TILDE, JAPANESE_HIRAGANA, MATH_OPERATORS, CHEMICAL_FORMULA, COORDINATES, EMAIL_LIKE_ID, PHONE_NUMBER, SKU_WITH_SLASH, CURRENCY_SYMBOL, PERCENTAGE, PARENTHESES, ENCODED_BRACKETS);

    @Override
    public Iterable<LegitimateTestCase> getLegitimateTestCases() {
        return ALL_LEGITIMATE_TEST_CASES;
    }

    @Override
    public String getDatabaseName() {
        return "Legitimate Special Characters Database (T32)";
    }

    @Override
    public String getDescription() {
        return "Comprehensive database of legitimate special character patterns including RFC 3986 characters, international text, scientific notation, and business identifiers";
    }

    public static class ArgumentsProvider
    extends LegitimatePatternDatabase.ArgumentsProvider<LegitimateSpecialCharactersDatabase> {
    }
}

