/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.database;

import de.cuioss.http.security.database.LegitimateTestCase;
import java.lang.reflect.ParameterizedType;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;

public interface LegitimatePatternDatabase {
    public Iterable<LegitimateTestCase> getLegitimateTestCases();

    default public Stream<LegitimateTestCase> streamTestCases() {
        return StreamSupport.stream(this.getLegitimateTestCases().spliterator(), false);
    }

    default public String getDatabaseName() {
        return this.getClass().getSimpleName();
    }

    default public String getDescription() {
        return "Legitimate pattern database containing valid URL patterns for false positive prevention";
    }

    public static abstract class ArgumentsProvider<T extends LegitimatePatternDatabase>
    implements org.junit.jupiter.params.provider.ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            Class<?> providerClass = this.getClass();
            ParameterizedType genericSuperclass = (ParameterizedType)providerClass.getGenericSuperclass();
            Class databaseClass = (Class)genericSuperclass.getActualTypeArguments()[0];
            LegitimatePatternDatabase database = (LegitimatePatternDatabase)databaseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return database.streamTestCases().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

