/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.database;

import de.cuioss.http.security.core.UrlSecurityFailureType;
import de.cuioss.http.security.database.AttackDatabase;
import de.cuioss.http.security.database.AttackTestCase;
import java.util.List;

public class HomographAttackDatabase
implements AttackDatabase {
    public static final AttackTestCase CYRILLIC_ADMIN_ATTACK = new AttackTestCase("\u0430dmin", UrlSecurityFailureType.INVALID_CHARACTER, "Homograph attack using Cyrillic '\u0430' (U+0430) instead of Latin 'a' (U+0061) in 'admin'. This creates a visually identical administrative term that can bypass exact string matching security filters while appearing legitimate to users attempting administrative access.", "INVALID_CHARACTER is expected because Cyrillic characters in what appears to be a Latin administrative term indicates potential homograph spoofing for privilege escalation bypass.");
    public static final AttackTestCase CYRILLIC_ROOT_ATTACK = new AttackTestCase("r\u043e\u043et", UrlSecurityFailureType.INVALID_CHARACTER, "Homograph attack using Cyrillic '\u043e' (U+043E) instead of Latin 'o' (U+006F) in 'root'. This targets the root user account with visually deceptive characters that maintain the appearance of the legitimate root username while using different Unicode code points.", "INVALID_CHARACTER is expected due to the presence of Cyrillic characters in what appears to be a system administration username, indicating homograph-based authentication bypass attempts.");
    public static final AttackTestCase CYRILLIC_PASSWORD_ATTACK = new AttackTestCase("\u0440\u0430\u0455\u0455word", UrlSecurityFailureType.INVALID_CHARACTER, "Complex homograph attack using multiple Cyrillic substitutions: '\u0440' (U+0440) for 'p', '\u0430' (U+0430) for 'a', and '\u0455' (U+0455) for 's' in 'password'. This demonstrates sophisticated multi-character homograph attacks targeting authentication systems.", "INVALID_CHARACTER is expected because multiple Cyrillic character substitutions in a security-sensitive term like 'password' represent advanced homograph spoofing techniques.");
    public static final AttackTestCase CYRILLIC_SYSTEM_ATTACK = new AttackTestCase("\u0455\u0443\u0455t\u0435m", UrlSecurityFailureType.INVALID_CHARACTER, "Advanced homograph attack using Cyrillic '\u0455' (U+0455), '\u0443' (U+0443), and '\u0435' (U+0435) in 'system'. This targets system-level access controls with multiple visually deceptive character substitutions that maintain readability while bypassing string-based filters.", "INVALID_CHARACTER is expected because the combination of multiple Cyrillic characters in a system administration term indicates sophisticated homograph-based security bypass attempts.");
    public static final AttackTestCase APPLE_DOMAIN_SPOOFING = new AttackTestCase("\u0430pple.com", UrlSecurityFailureType.INVALID_CHARACTER, "Domain spoofing attack using Cyrillic '\u0430' (U+0430) instead of Latin 'a' in apple.com. This creates a domain that is visually identical to the legitimate Apple domain but technically different, allowing attackers to register deceptive domains for phishing and fraud.", "INVALID_CHARACTER is expected because Cyrillic characters in what appears to be a major brand domain (.com) indicates potential domain spoofing for phishing or trademark abuse.");
    public static final AttackTestCase GOOGLE_DOMAIN_SPOOFING = new AttackTestCase("g\u043e\u043egle.com", UrlSecurityFailureType.INVALID_CHARACTER, "Domain spoofing using Cyrillic '\u043e' (U+043E) for both 'o' characters in google.com. This demonstrates how multiple identical homograph substitutions can create convincing domain spoofs that are virtually impossible for users to distinguish from legitimate domains.", "INVALID_CHARACTER is expected due to multiple Cyrillic '\u043e' characters in a major technology brand domain, indicating systematic homograph spoofing for potential phishing attacks.");
    public static final AttackTestCase MICROSOFT_DOMAIN_SPOOFING = new AttackTestCase("mi\u0441ro\u0455oft.com", UrlSecurityFailureType.INVALID_CHARACTER, "Sophisticated domain spoofing using Cyrillic '\u0441' (U+0441) and '\u0455' (U+0455) in microsoft.com. This targets one of the world's largest technology companies with visually perfect character substitutions that maintain complete visual fidelity.", "INVALID_CHARACTER is expected because multiple Cyrillic character substitutions in the Microsoft brand domain represent high-value target spoofing for corporate phishing attacks.");
    public static final AttackTestCase GREEK_ALPHA_ADMIN = new AttackTestCase("\u03b1dmin", UrlSecurityFailureType.INVALID_CHARACTER, "Greek homograph attack using Greek small letter alpha '\u03b1' (U+03B1) instead of Latin 'a' in 'admin'. This demonstrates how Greek script characters can be used for administrative privilege bypass through visual character deception.", "INVALID_CHARACTER is expected because Greek characters in administrative terms indicate potential homograph-based authentication or authorization bypass techniques.");
    public static final AttackTestCase GREEK_OMICRON_ROOT = new AttackTestCase("r\u03bf\u03bft", UrlSecurityFailureType.INVALID_CHARACTER, "Greek homograph attack using Greek small letter omicron '\u03bf' (U+03BF) for 'o' characters in 'root'. This shows how Greek script can provide alternative homograph options when Cyrillic substitutions might be detected or filtered.", "INVALID_CHARACTER is expected due to Greek characters in system administration usernames, representing homograph spoofing for root privilege escalation attempts.");
    public static final AttackTestCase GREEK_RHO_PASSWORD = new AttackTestCase("\u03c1assword", UrlSecurityFailureType.INVALID_CHARACTER, "Greek homograph using Greek small letter rho '\u03c1' (U+03C1) instead of Latin 'p' in 'password'. This demonstrates the Greek script's effectiveness for creating deceptive authentication terms that bypass Latin-based security filters.", "INVALID_CHARACTER is expected because Greek characters in security-sensitive terms like 'password' indicate potential authentication system bypass through homograph deception.");
    public static final AttackTestCase MATHEMATICAL_BOLD_ADMIN = new AttackTestCase("\ud835\udc1admin", UrlSecurityFailureType.INVALID_CHARACTER, "Mathematical script homograph using Mathematical bold small 'a' (U+1D41A) in 'admin'. This demonstrates how Unicode mathematical characters can be used for sophisticated visual deception in administrative contexts while bypassing standard character filters.", "INVALID_CHARACTER is expected because mathematical Unicode characters in administrative terms represent advanced homograph techniques using specialized Unicode blocks for security bypass.");
    public static final AttackTestCase MATHEMATICAL_SCRIPT_CONFIG = new AttackTestCase("\ud835\udc1c\ud835\udc28\ud835\udc27\ud835\udc1f\ud835\udc22\ud835\udc20", UrlSecurityFailureType.INVALID_CHARACTER, "Complete mathematical script transformation of 'config' using Mathematical bold characters. This shows how entire words can be transformed using consistent mathematical character sets while maintaining perfect visual similarity for configuration access bypass.", "INVALID_CHARACTER is expected because complete mathematical Unicode transformation of configuration terms indicates sophisticated homograph attacks targeting system configuration access.");
    public static final AttackTestCase FULLWIDTH_SECURE = new AttackTestCase("\uff53\uff45\uff43\uff55\uff52\uff45", UrlSecurityFailureType.INVALID_CHARACTER, "Fullwidth character attack transforming 'secure' using East Asian fullwidth Latin characters (U+FF01-FF5E range). These characters are designed for Asian typography but appear identical to regular Latin characters, creating perfect visual homographs.", "INVALID_CHARACTER is expected because fullwidth characters in security-related terms indicate East Asian typography-based homograph attacks for security context bypass.");
    public static final AttackTestCase FULLWIDTH_LOGIN = new AttackTestCase("\uff4c\uff4f\uff47\uff49\uff4e", UrlSecurityFailureType.INVALID_CHARACTER, "Fullwidth character homograph of 'login' using complete East Asian typography transformation. This demonstrates how fullwidth characters can create authentication bypass opportunities while maintaining complete visual compatibility with standard Latin text.", "INVALID_CHARACTER is expected due to fullwidth character usage in authentication terms, representing typography-based homograph spoofing for login system bypass.");
    public static final AttackTestCase CYRILLIC_EXE_SPOOFING = new AttackTestCase(".\u0435\u0445\u0435", UrlSecurityFailureType.INVALID_CHARACTER, "File extension spoofing using Cyrillic '\u0435' (U+0435) and '\u0445' (U+0445) in '.exe'. This creates a file extension that appears identical to the dangerous '.exe' extension but uses different Unicode characters, potentially bypassing file type restrictions.", "INVALID_CHARACTER is expected because Cyrillic characters in executable file extensions indicate potential file type filtering bypass through homograph deception.");
    public static final AttackTestCase CYRILLIC_PDF_SPOOFING = new AttackTestCase(".\u0440df", UrlSecurityFailureType.INVALID_CHARACTER, "File extension homograph using Cyrillic '\u0440' (U+0440) in '.pdf'. This demonstrates how document format extensions can be spoofed using visually identical characters to bypass file type security controls while appearing as legitimate PDF files.", "INVALID_CHARACTER is expected because Cyrillic characters in document file extensions represent file type spoofing attempts using homograph character substitution.");
    public static final AttackTestCase MIXED_SCRIPT_APPLE = new AttackTestCase("\u03b1\u0440ple.com", UrlSecurityFailureType.INVALID_CHARACTER, "Sophisticated mixed script attack combining Greek alpha '\u03b1' and Cyrillic '\u0440' in apple.com domain. This demonstrates advanced homograph techniques that mix different Unicode scripts to create maximum visual deception while evading single-script detection methods.", "INVALID_CHARACTER is expected because mixing multiple Unicode scripts (Greek + Cyrillic) in major brand domains indicates sophisticated multi-vector homograph spoofing attacks.");
    public static final AttackTestCase MIXED_SCRIPT_GITHUB = new AttackTestCase("\u0261ithub.\u0441\u03bfm", UrlSecurityFailureType.INVALID_CHARACTER, "Complex mixed script attack using Latin script '\u0261' (U+0261), Cyrillic '\u0441', and Greek '\u03bf' in github.com. This shows how multiple Unicode scripts can be strategically combined to target developer platforms with sophisticated homograph deception techniques.", "INVALID_CHARACTER is expected due to the strategic combination of Latin script, Cyrillic, and Greek characters in a major development platform domain, indicating advanced homograph targeting.");
    public static final AttackTestCase CYRILLIC_SCRIPT_COMMAND = new AttackTestCase("\u0455\u0441ript", UrlSecurityFailureType.INVALID_CHARACTER, "System command spoofing using Cyrillic '\u0455' (U+0455) and '\u0441' (U+0441) in 'script'. This targets JavaScript and system scripting contexts with homograph characters that can bypass command filtering while maintaining the appearance of legitimate script commands.", "INVALID_CHARACTER is expected because Cyrillic characters in scripting commands indicate potential code execution bypass through homograph substitution in script execution contexts.");
    public static final AttackTestCase CYRILLIC_EXEC_COMMAND = new AttackTestCase("\u0435\u0445\u0435\u0441", UrlSecurityFailureType.INVALID_CHARACTER, "Executive command spoofing using Cyrillic '\u0435' and '\u0441' in 'exec'. This demonstrates homograph attacks targeting system execution commands that could bypass command injection filters while appearing as legitimate system execution calls.", "INVALID_CHARACTER is expected because Cyrillic characters in system execution commands represent potential command injection bypass through executive command homograph spoofing.");
    public static final AttackTestCase JAVASCRIPT_PROTOCOL_SPOOFING = new AttackTestCase("j\u0430v\u0430script:", UrlSecurityFailureType.INVALID_CHARACTER, "JavaScript protocol spoofing using Cyrillic '\u0430' (U+0430) characters in 'javascript:' URI scheme. This can bypass XSS filters that block the javascript: protocol by using visually identical but technically different characters in malicious script execution attempts.", "INVALID_CHARACTER is expected because Cyrillic characters in JavaScript URI schemes indicate potential XSS filter bypass through protocol homograph spoofing for script injection.");
    public static final AttackTestCase FILE_PROTOCOL_SPOOFING = new AttackTestCase("fil\u0435://", UrlSecurityFailureType.INVALID_CHARACTER, "File protocol spoofing using Cyrillic '\u0435' (U+0435) in 'file://' URI scheme. This demonstrates how local file access protocols can be spoofed using homograph characters to potentially bypass protocol-based security restrictions.", "INVALID_CHARACTER is expected because Cyrillic characters in file URI schemes represent potential local file access bypass through protocol homograph deception.");
    private static final List<AttackTestCase> ALL_ATTACK_TEST_CASES = List.of(CYRILLIC_ADMIN_ATTACK, CYRILLIC_ROOT_ATTACK, CYRILLIC_PASSWORD_ATTACK, CYRILLIC_SYSTEM_ATTACK, APPLE_DOMAIN_SPOOFING, GOOGLE_DOMAIN_SPOOFING, MICROSOFT_DOMAIN_SPOOFING, GREEK_ALPHA_ADMIN, GREEK_OMICRON_ROOT, GREEK_RHO_PASSWORD, MATHEMATICAL_BOLD_ADMIN, MATHEMATICAL_SCRIPT_CONFIG, FULLWIDTH_SECURE, FULLWIDTH_LOGIN, CYRILLIC_EXE_SPOOFING, CYRILLIC_PDF_SPOOFING, MIXED_SCRIPT_APPLE, MIXED_SCRIPT_GITHUB, CYRILLIC_SCRIPT_COMMAND, CYRILLIC_EXEC_COMMAND, JAVASCRIPT_PROTOCOL_SPOOFING, FILE_PROTOCOL_SPOOFING);

    @Override
    public Iterable<AttackTestCase> getAttackTestCases() {
        return ALL_ATTACK_TEST_CASES;
    }

    @Override
    public String getDatabaseName() {
        return "Homograph Attack Database";
    }

    @Override
    public String getDescription() {
        return "Comprehensive database of Unicode homograph attack patterns including Cyrillic, Greek, Mathematical, and Fullwidth character substitutions for domain spoofing, command injection, and authentication bypass";
    }

    public static class ArgumentsProvider
    extends AttackDatabase.ArgumentsProvider<HomographAttackDatabase> {
    }
}

