/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.http.security.database;

import de.cuioss.http.security.core.UrlSecurityFailureType;

public record AttackTestCase(String attackString, UrlSecurityFailureType expectedFailureType, String attackDescription, String detectionRationale) {
    public AttackTestCase {
        if (attackString == null || attackString.isBlank()) {
            throw new IllegalArgumentException("Attack string must not be null or blank");
        }
        if (expectedFailureType == null) {
            throw new IllegalArgumentException("Expected failure type must not be null");
        }
        if (attackDescription == null || attackDescription.isBlank()) {
            throw new IllegalArgumentException("Attack description must not be null or blank");
        }
        if (detectionRationale == null || detectionRationale.isBlank()) {
            throw new IllegalArgumentException("Detection rationale must not be null or blank");
        }
    }

    @Override
    public String toString() {
        return "AttackTestCase[attackString='%s', expectedFailureType=%s, attackDescription='%s', detectionRationale='%s']".formatted(this.attackString, this.expectedFailureType, this.attackDescription, this.detectionRationale);
    }

    public String getCompactSummary() {
        return "%s -> %s".formatted(this.attackString.length() > 50 ? this.attackString.substring(0, 47) + "..." : this.attackString, this.expectedFailureType);
    }
}

