/*
 * Decompiled with CFR 0.152.
 */
package de.csgis.commons.json;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.sf.json.JSONObject;
import org.geotools.geojson.geom.GeometryJSON;

public class GeojsonPGHelper {
    private static final String GEOJSON_PROPS = "properties";
    private static final String GEOJSON_GEOM = "geometry";
    private Connection conn;
    private String table;
    private String idColumn;
    private String geomColumn;
    private int srid;
    private String fields;
    private String values;
    private SimpleDateFormat[] formats;

    public GeojsonPGHelper(String table, String idColumn, String geomColumn, int srid) {
        this.idColumn = idColumn;
        this.geomColumn = geomColumn;
        this.table = table;
        this.srid = srid;
        for (SimpleDateFormat format : this.formats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX"), new SimpleDateFormat("yyyy-MM-ddX")}) {
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public void insert(JSONObject geojson) throws SQLException, IOException {
        this.processFields(geojson);
        String sql = "INSERT INTO " + this.table + " (" + this.fields + ") VALUES (" + this.values + ")";
        PreparedStatement st = this.prepareStatement(geojson, sql);
        st.executeUpdate();
    }

    public void update(JSONObject geojson) throws SQLException, IOException {
        this.processFields(geojson);
        String sql = "UPDATE " + this.table + " SET (" + this.fields + ") = (" + this.values + ") WHERE " + this.idColumn + " = ?";
        PreparedStatement st = this.prepareStatement(geojson, sql);
        JSONObject properties = geojson.getJSONObject(GEOJSON_PROPS);
        Object id = properties.get(this.idColumn);
        if (id == null) {
            throw new IOException("GeoJSON missing id('" + this.idColumn + "') property");
        }
        st.setObject(properties.size() + 3, id);
        st.executeUpdate();
    }

    public void delete(JSONObject geojson) throws SQLException, IOException {
        String sql = "DELETE FROM " + this.table + " WHERE " + this.idColumn + " = ?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        Object id = geojson.getJSONObject(GEOJSON_PROPS).get(this.idColumn);
        if (id == null) {
            throw new IOException("GeoJSON missing id('" + this.idColumn + "') property");
        }
        st.setObject(1, id);
        st.executeUpdate();
    }

    private void processFields(JSONObject geojson) {
        JSONObject properties = geojson.getJSONObject(GEOJSON_PROPS);
        this.values = "";
        this.fields = "";
        for (Object key : properties.keySet()) {
            this.fields = this.fields + key.toString() + ", ";
            this.values = this.values + "?, ";
        }
        this.fields = this.fields + this.geomColumn;
        this.values = this.values + "ST_GeomFromText(?, ?)";
    }

    private PreparedStatement prepareStatement(JSONObject geojson, String sql) throws SQLException, IOException {
        PreparedStatement st = this.conn.prepareStatement(sql);
        JSONObject properties = geojson.getJSONObject(GEOJSON_PROPS);
        int j = 1;
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            Date date = null;
            for (SimpleDateFormat format : this.formats) {
                try {
                    date = format.parse(value.toString());
                    break;
                }
                catch (ParseException parseException) {
                }
            }
            if (date != null) {
                st.setDate(j++, new java.sql.Date(date.getTime()));
                continue;
            }
            st.setObject(j++, value);
        }
        String geoJsonGeom = geojson.getJSONObject(GEOJSON_GEOM).toString();
        Geometry geom = new GeometryJSON().read((Object)geoJsonGeom);
        if (geom == null) {
            throw new IOException("Invalid GeoJSON geometry");
        }
        st.setString(j++, geom.toText());
        st.setInt(j++, this.srid);
        return st;
    }

    public String getTable() {
        return this.table;
    }
}

