/*
 * Decompiled with CFR 0.152.
 */
package de.csgis.commons;

import net.sf.json.JSONObject;

public class JSONUtils {
    private JSONUtils() {
    }

    public static JSONObject merge(JSONObject defaultObj, JSONObject overrides) {
        JSONObject ret = JSONObject.fromObject((Object)(defaultObj != null && !defaultObj.isNullObject() ? defaultObj.toString() : "{}"));
        if (overrides != null && !overrides.isEmpty() && !overrides.isNullObject()) {
            JSONUtils.mergeRecursive(ret, overrides);
        }
        return ret;
    }

    private static void mergeRecursive(JSONObject obj, JSONObject overrides) {
        for (Object key : obj.keySet()) {
            if (!overrides.containsKey(key)) continue;
            Object defaultElement = obj.get(key);
            Object overrideElement = overrides.get(key);
            if (defaultElement instanceof JSONObject) {
                JSONObject defaultObj = (JSONObject)defaultElement;
                if (overrideElement instanceof JSONObject) {
                    JSONUtils.mergeRecursive(defaultObj, (JSONObject)overrideElement);
                    continue;
                }
                obj.put(key, overrideElement);
                continue;
            }
            obj.put(key, overrideElement);
        }
        for (Object key : overrides.keySet()) {
            if (obj.containsKey(key)) continue;
            obj.put(key, overrides.get(key));
        }
    }
}

