/*
 * Decompiled with CFR 0.152.
 */
package de.csgis.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class JSONContentProvider {
    private static final Logger logger = Logger.getLogger(JSONContentProvider.class);
    private File directory;
    private Map<String, JSONObject> contents;
    private Map<String, Long> lastFileAccesses = new HashMap<String, Long>();

    public JSONContentProvider(String directory) {
        this.directory = new File(directory);
        this.contents = new HashMap<String, JSONObject>();
        this.lastFileAccesses = new HashMap<String, Long>();
    }

    public Map<String, JSONObject> get() {
        this.updateContentsIfNeeded();
        return this.contents;
    }

    private void updateContentsIfNeeded() {
        File[] files = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        });
        if (files == null) {
            this.contents.clear();
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String path : this.contents.keySet()) {
            File file = new File(this.directory, path + ".json");
            if (file.exists()) continue;
            toRemove.add(path);
        }
        for (String path : toRemove) {
            this.contents.remove(path);
        }
        for (Iterator<String> iterator : files) {
            String name = ((File)((Object)iterator)).getName();
            String basename = name.substring(0, name.lastIndexOf(46));
            JSONObject jsonContent = this.contents.get(basename);
            Long lastAccess = this.lastFileAccesses.get(basename);
            if (jsonContent != null && lastAccess != null && ((File)((Object)iterator)).lastModified() < lastAccess) continue;
            try {
                String content = IOUtils.toString((InputStream)new FileInputStream((File)((Object)iterator)));
                this.contents.put(basename, JSONObject.fromObject((Object)content));
                this.lastFileAccesses.put(basename, new Long(System.currentTimeMillis()));
            }
            catch (JSONException e) {
                logger.error((Object)"Cannot read JSON plugin config from config dir", (Throwable)e);
                this.contents.remove(basename);
            }
            catch (IOException e) {
                logger.error((Object)"Cannot read JSON plugin config from config dir", (Throwable)e);
                this.contents.remove(basename);
            }
        }
    }
}

