/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.service.device;

import de.csdev.ebus.command.EBusCommandException;
import de.csdev.ebus.command.EBusCommandRegistry;
import de.csdev.ebus.command.EBusCommandUtils;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.core.EBusConnectorEventListener;
import de.csdev.ebus.core.EBusControllerException;
import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.core.IEBusController;
import de.csdev.ebus.service.device.EBusDeviceTable;
import de.csdev.ebus.service.device.IEBusDevice;
import de.csdev.ebus.service.device.IEBusDeviceTableListener;
import de.csdev.ebus.service.parser.IEBusParserListener;
import de.csdev.ebus.utils.EBusUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EBusDeviceTableService
extends EBusConnectorEventListener
implements IEBusParserListener,
IEBusDeviceTableListener {
    private static final Logger logger = LoggerFactory.getLogger(EBusDeviceTableService.class);
    private @NonNull IEBusController controller;
    private @NonNull Integer scanQueueId = -1;
    private @NonNull EBusCommandRegistry configurationProvider;
    private @NonNull EBusDeviceTable deviceTable;
    private boolean disableIdentificationRequests = false;
    private byte scanSlaveAddress = 0;
    private boolean scanRunning = false;

    public EBusDeviceTableService(@NonNull IEBusController controller, @NonNull EBusCommandRegistry configurationProvider, @NonNull EBusDeviceTable deviceTable) {
        Objects.requireNonNull(controller);
        Objects.requireNonNull(configurationProvider);
        Objects.requireNonNull(deviceTable);
        this.controller = controller;
        this.configurationProvider = configurationProvider;
        this.deviceTable = deviceTable;
        this.controller.addEBusEventListener(this);
    }

    public boolean isDisableIdentificationRequests() {
        return this.disableIdentificationRequests;
    }

    public void setDisableIdentificationRequests(boolean disableIdentificationRequests) {
        this.disableIdentificationRequests = disableIdentificationRequests;
    }

    public void inquiryDeviceExistence() {
        if (this.scanQueueId != -1) {
            logger.debug("Inquiry is still in progress ...");
            return;
        }
        if (this.controller.getConnectionStatus() != IEBusController.ConnectionStatus.CONNECTED) {
            logger.debug("Skip eBUS scan due to connection issues ...");
            return;
        }
        logger.debug("Start eBUS scan  ...");
        byte masterAddress = this.deviceTable.getOwnDevice().getMasterAddress();
        IEBusCommandMethod command = this.configurationProvider.getCommandMethodById("std", "common.inquiry_of_existence", IEBusCommandMethod.Method.BROADCAST);
        if (command == null) {
            throw new IllegalStateException("Unable to load command COMMAND_INQ_EXISTENCE!");
        }
        try {
            ByteBuffer buffer = EBusCommandUtils.buildMasterTelegram(command, masterAddress, (byte)-2, null);
            this.scanQueueId = this.controller.addToSendQueue(EBusUtils.toByteArray(buffer), 2);
        }
        catch (EBusCommandException | EBusTypeException | EBusControllerException e) {
            logger.error("error!", (Throwable)e);
        }
    }

    public void startDeviceScan() {
        if (this.controller.getConnectionStatus() != IEBusController.ConnectionStatus.CONNECTED) {
            logger.debug("Skip eBUS device scan due to connection issues ...");
            return;
        }
        if (this.scanRunning) {
            logger.debug("eBUS scan is already running! Skip start ...");
            return;
        }
        if (this.scanQueueId != -1) {
            logger.debug("Inquiry is still in progress ...");
            return;
        }
        this.scanSlaveAddress = (byte)2;
        this.scanRunning = true;
        this.scanDevice2(false);
    }

    public void stopDeviceScan() {
        this.scanRunning = false;
    }

    private synchronized boolean scanDevice2(boolean nextDevice) {
        if (nextDevice) {
            Byte addr = this.nextSlaveAddress(this.scanSlaveAddress);
            if (addr == null) {
                return false;
            }
            this.scanSlaveAddress = addr;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Scan address {} ...", (Object)EBusUtils.toHexDumpString(this.scanSlaveAddress));
        }
        byte masterAddress = this.deviceTable.getOwnDevice().getMasterAddress();
        IEBusCommandMethod command = this.configurationProvider.getCommandMethodById("std", "common.identification", IEBusCommandMethod.Method.GET);
        if (command == null) {
            throw new IllegalStateException("Unable to load command COMMAND_IDENTIFICATION!");
        }
        try {
            ByteBuffer buffer = EBusCommandUtils.buildMasterTelegram(command, masterAddress, this.scanSlaveAddress, null);
            this.scanQueueId = this.controller.addToSendQueue(EBusUtils.toByteArray(buffer), 2);
            return true;
        }
        catch (EBusCommandException | EBusTypeException | EBusControllerException e) {
            logger.error("error!", (Throwable)e);
            return false;
        }
    }

    private @Nullable Byte nextSlaveAddress(byte slaveAddress) {
        if (slaveAddress == -3) {
            return null;
        }
        while (EBusUtils.isMasterAddress(slaveAddress = (byte)(slaveAddress + 1)) || slaveAddress == -2) {
        }
        return slaveAddress;
    }

    public void dispose() {
        this.controller.removeEBusEventListener(this);
    }

    private void sendSignOfLife() {
        byte masterAddress = this.deviceTable.getOwnDevice().getMasterAddress();
        IEBusCommandMethod command = this.configurationProvider.getCommandMethodById("std", "common.sign_of_life", IEBusCommandMethod.Method.BROADCAST);
        if (command == null) {
            throw new IllegalStateException("Unable to load command COMMAND_SIGN_OF_LIFE!");
        }
        try {
            ByteBuffer buffer = EBusCommandUtils.buildMasterTelegram(command, masterAddress, (byte)-2, null);
            this.controller.addToSendQueue(EBusUtils.toByteArray(buffer), 2);
        }
        catch (EBusCommandException | EBusTypeException | EBusControllerException e) {
            logger.error("error!", (Throwable)e);
        }
    }

    public void sendIdentificationRequest(byte slaveAddress) {
        if (this.controller.getConnectionStatus() != IEBusController.ConnectionStatus.CONNECTED) {
            logger.debug("Skip eBUS identification due to connection issues ...");
            return;
        }
        byte masterAddress = this.deviceTable.getOwnDevice().getMasterAddress();
        IEBusCommandMethod command = this.configurationProvider.getCommandMethodById("std", "common.identification", IEBusCommandMethod.Method.GET);
        if (command == null) {
            logger.warn("Unable to load command with id common.identification");
            return;
        }
        if (EBusUtils.isMasterAddress(slaveAddress)) {
            logger.error("The given address is a master address, not a slave address!");
            return;
        }
        try {
            ByteBuffer buffer = EBusCommandUtils.buildMasterTelegram(command, masterAddress, slaveAddress, null);
            this.controller.addToSendQueue(EBusUtils.toByteArray(buffer), 2);
        }
        catch (EBusCommandException | EBusTypeException | EBusControllerException e) {
            logger.error("error!", (Throwable)e);
        }
    }

    @Override
    public void onTelegramReceived(byte @NonNull [] receivedData, @Nullable Integer sendQueueId) {
        this.deviceTable.updateDevice(receivedData[0], null);
        this.deviceTable.updateDevice(receivedData[1], null);
        if (sendQueueId != null && sendQueueId.equals(this.scanQueueId)) {
            if (this.scanRunning) {
                if (!this.scanDevice2(true)) {
                    this.stopDeviceScan();
                }
            } else {
                logger.debug("Scan broadcast has been send out!");
            }
            this.scanQueueId = -1;
        }
    }

    @Override
    public void onTelegramException(@NonNull EBusDataException exception, @Nullable Integer sendQueueId) {
        if (sendQueueId != null && sendQueueId.equals(this.scanQueueId)) {
            if (this.scanRunning) {
                if (!this.scanDevice2(true)) {
                    this.stopDeviceScan();
                }
            } else {
                logger.debug("Scan broadcast failed!");
            }
            this.scanQueueId = -1;
        }
    }

    @Override
    public void onTelegramResolved(@NonNull IEBusCommandMethod commandChannel, @NonNull Map<@NonNull String, @Nullable Object> result, byte @NonNull [] receivedData, @Nullable Integer sendQueueId) {
        String id = commandChannel.getParent().getId();
        Byte slaveAddress = receivedData[1];
        if (id.equals("common.sign_of_life")) {
            this.deviceTable.updateDevice(slaveAddress, null);
        } else if (id.equals("common.inquiry_of_existence")) {
            this.sendSignOfLife();
        } else if (id.equals("common.identification")) {
            this.deviceTable.updateDevice(slaveAddress, result);
        }
    }

    @Override
    public void onEBusDeviceUpdate(@NonNull IEBusDeviceTableListener.TYPE type, @NonNull IEBusDevice device) {
        if (!type.equals((Object)IEBusDeviceTableListener.TYPE.UPDATE_ACTIVITY)) {
            logger.debug("DATA TABLE UPDATE {}", (Object)device);
        }
        if (type.equals((Object)IEBusDeviceTableListener.TYPE.NEW) && !this.disableIdentificationRequests) {
            this.sendIdentificationRequest(device.getSlaveAddress());
        }
    }

    @Override
    public void onTelegramResolveFailed(@Nullable IEBusCommandMethod commandChannel, byte @Nullable [] receivedData, @Nullable Integer sendQueueId, @Nullable String exceptionMessage) {
    }
}

