/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core.connection;

import de.csdev.ebus.core.connection.AbstractEBusConnection;
import de.csdev.ebus.utils.CommonsUtils;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusSerialNRJavaSerialConnection
extends AbstractEBusConnection {
    private static final Logger logger = LoggerFactory.getLogger(EBusSerialNRJavaSerialConnection.class);
    private SerialPort serialPort;
    private String port;

    public EBusSerialNRJavaSerialConnection(String port) {
        this.port = port;
    }

    @Override
    public boolean open() throws IOException {
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.port);
            if (portIdentifier != null) {
                this.serialPort = portIdentifier.open("de.csdev.ebus", 2000);
                this.serialPort.setSerialPortParams(2400, 8, 1, 0);
                this.serialPort.enableReceiveThreshold(1);
                this.serialPort.disableReceiveTimeout();
                this.serialPort.setOutputBufferSize(1);
                this.serialPort.setInputBufferSize(50);
                this.outputStream = this.serialPort.getOutputStream();
                this.inputStream = this.serialPort.getInputStream();
                this.outputStream.flush();
                if (this.inputStream.markSupported()) {
                    this.inputStream.reset();
                }
                this.serialPort.addEventListener(event -> {
                    if (event.getEventType() == 1) {
                        InputStream inputStream = this.inputStream;
                        synchronized (inputStream) {
                            this.inputStream.notifyAll();
                        }
                    }
                });
                this.serialPort.notifyOnDataAvailable(true);
                return true;
            }
        }
        catch (NoSuchPortException e) {
            logger.error("Unable to connect to serial port {}", (Object)this.port);
        }
        catch (PortInUseException e) {
            logger.error("Serial port {} is already in use", (Object)this.port);
        }
        catch (UnsupportedCommOperationException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        catch (TooManyListenersException e) {
            logger.error("Too many listeners error!", (Throwable)e);
        }
        this.serialPort = null;
        return false;
    }

    @Override
    public boolean close() throws IOException {
        if (this.serialPort == null) {
            return false;
        }
        Thread shutdownThread = new Thread(() -> {
            CommonsUtils.closeQuietly(this.inputStream);
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                CommonsUtils.closeQuietly(this.outputStream);
            }
            if (this.serialPort != null) {
                this.serialPort.notifyOnDataAvailable(false);
                this.serialPort.removeEventListener();
                this.serialPort.close();
                this.serialPort = null;
            }
            this.inputStream = null;
            this.outputStream = null;
        }, "eBUS serial shutdown thread");
        shutdownThread.start();
        try {
            shutdownThread.join(2000L);
        }
        catch (InterruptedException e) {
            logger.error("error!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readByte(boolean lowLatency) throws IOException {
        if (lowLatency) {
            return this.inputStream.read();
        }
        if (this.inputStream.available() > 0) {
            return this.inputStream.read();
        }
        InputStream inputStream = this.inputStream;
        synchronized (inputStream) {
            try {
                this.inputStream.wait(3000L);
                return this.inputStream.read();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return -1;
            }
        }
    }
}

