/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core.connection;

import de.csdev.ebus.core.connection.IEBusConnection;
import de.csdev.ebus.utils.EmulatorCapture;
import java.io.IOException;

public class EBusCaptureProxyConnection
implements IEBusConnection {
    private IEBusConnection proxyConnection;
    private EmulatorCapture captureWriter;

    public EBusCaptureProxyConnection(IEBusConnection proxyConnection, EmulatorCapture captureWriter) {
        this.proxyConnection = proxyConnection;
        this.captureWriter = captureWriter;
    }

    @Override
    public boolean open() throws IOException {
        return this.proxyConnection.open();
    }

    @Override
    public boolean close() throws IOException {
        this.captureWriter.close();
        return this.proxyConnection.close();
    }

    @Override
    public boolean isOpen() throws IOException {
        return this.proxyConnection.isOpen();
    }

    @Override
    public int readByte(boolean lowLatency) throws IOException {
        int readByte = this.proxyConnection.readByte(lowLatency);
        if (readByte != -1) {
            this.captureWriter.write(new byte[]{(byte)(readByte & 0xFF)});
        }
        return readByte;
    }

    @Override
    public boolean isReceiveBufferEmpty() throws IOException {
        return this.proxyConnection.isReceiveBufferEmpty();
    }

    @Override
    public int readBytes(byte[] buffer) throws IOException {
        int readBytes = this.proxyConnection.readBytes(buffer);
        this.captureWriter.write(buffer, readBytes);
        return readBytes;
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.proxyConnection.writeByte(b);
    }

    @Override
    public void reset() throws IOException {
        this.proxyConnection.reset();
    }
}

