/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.std.AbstractEBusTypeUnsignedNumber;
import de.csdev.ebus.utils.EBusUtils;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import org.eclipse.jdt.annotation.Nullable;

public class EBusTypeData1c
extends AbstractEBusTypeUnsignedNumber {
    public static String TYPE_DATA1C = "data1c";
    private static String[] supportedTypes = new String[]{TYPE_DATA1C};

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        return 1;
    }

    @Override
    public BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        BigDecimal decodeInt = super.decodeInt(data);
        return decodeInt.divide(BigDecimal.valueOf(2L));
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal b = NumberUtils.toBigDecimal(data);
        if (b == null) {
            throw new EBusTypeException("Unable to convert input data to number!");
        }
        return super.encodeInt(b.multiply(BigDecimal.valueOf(2L)));
    }

    public String toString() {
        return "EBusTypeData1c [replaceValue=" + EBusUtils.toHexDumpString(this.getReplaceValue()).toString() + "]";
    }
}

