/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.ext;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.command.datatypes.std.EBusTypeBCD;
import de.csdev.ebus.command.datatypes.std.EBusTypeChar;
import de.csdev.ebus.command.datatypes.std.EBusTypeWord;
import de.csdev.ebus.utils.EBusDateTime;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.Nullable;

public class EBusTypeDate
extends EBusAbstractType<EBusDateTime> {
    public static String TYPE_DATE = "date";
    public static String DEFAULT = "std";
    public static String SHORT = "short";
    public static String HEX = "hex";
    public static String HEX_SHORT = "hex_short";
    public static String DAYS = "days";
    private static String[] supportedTypes = new String[]{TYPE_DATE};
    private String variant = DEFAULT;

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        if (this.variant.equals(DEFAULT)) {
            return 4;
        }
        if (this.variant.equals(HEX)) {
            return 4;
        }
        if (this.variant.equals(SHORT)) {
            return 3;
        }
        if (this.variant.equals(HEX_SHORT)) {
            return 3;
        }
        if (this.variant.equals(DAYS)) {
            return 2;
        }
        return 0;
    }

    @Override
    public EBusDateTime decodeInt(byte @Nullable [] data) throws EBusTypeException {
        Objects.requireNonNull(data);
        IEBusType bcdType = this.types.getType(EBusTypeBCD.TYPE_BCD);
        IEBusType wordType = this.types.getType(EBusTypeWord.TYPE_WORD);
        IEBusType charType = this.types.getType(EBusTypeChar.TYPE_CHAR);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        BigDecimal day = null;
        BigDecimal month = null;
        BigDecimal year = null;
        if (data.length != this.getTypeLength()) {
            throw new EBusTypeException(String.format("Input byte array must have a length of %d bytes!", this.getTypeLength()));
        }
        if (StringUtils.equals((CharSequence)this.variant, (CharSequence)SHORT)) {
            day = (BigDecimal)bcdType.decode(new byte[]{data[0]});
            month = (BigDecimal)bcdType.decode(new byte[]{data[1]});
            year = (BigDecimal)bcdType.decode(new byte[]{data[2]});
        } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)DEFAULT)) {
            day = (BigDecimal)bcdType.decode(new byte[]{data[0]});
            month = (BigDecimal)bcdType.decode(new byte[]{data[1]});
            year = (BigDecimal)bcdType.decode(new byte[]{data[3]});
        } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)HEX_SHORT)) {
            day = (BigDecimal)charType.decode(new byte[]{data[0]});
            month = (BigDecimal)charType.decode(new byte[]{data[1]});
            year = (BigDecimal)charType.decode(new byte[]{data[2]});
        } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)HEX)) {
            day = (BigDecimal)charType.decode(new byte[]{data[0]});
            month = (BigDecimal)charType.decode(new byte[]{data[1]});
            year = (BigDecimal)charType.decode(new byte[]{data[3]});
        } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)DAYS)) {
            BigDecimal daysSince1900 = (BigDecimal)wordType.decode(data);
            if (daysSince1900 == null) {
                throw new EBusTypeException("Unable to compute days since 1990!");
            }
            calendar.set(1900, 0, 1, 0, 0);
            ((Calendar)calendar).add(6, daysSince1900.intValue());
        }
        if (day != null && month != null && year != null) {
            if (day.intValue() < 1 || day.intValue() > 31) {
                throw new EBusTypeException("A valid day must be in a range between 1-31 !");
            }
            if (month.intValue() < 1 || month.intValue() > 12) {
                throw new EBusTypeException("A valid day must be in a range between 1-12 !");
            }
        }
        if (year != null) {
            year = year.intValue() < 70 ? year.add(new BigDecimal(2000)) : year.add(new BigDecimal(1900));
            calendar.set(1, year.intValue());
        }
        if (month != null) {
            calendar.set(2, month.intValue() - 1);
        }
        if (day != null && day.intValue() > 0 && day.intValue() < 32) {
            calendar.set(5, day.intValue());
        }
        return new EBusDateTime(calendar, false, true);
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        IEBusType bcdType = this.types.getType(EBusTypeBCD.TYPE_BCD);
        IEBusType wordType = this.types.getType(EBusTypeWord.TYPE_WORD);
        IEBusType charType = this.types.getType(EBusTypeChar.TYPE_CHAR);
        Calendar calendar = null;
        byte[] result = new byte[this.getTypeLength()];
        if (data instanceof EBusDateTime) {
            calendar = ((EBusDateTime)data).getCalendar();
        } else if (data instanceof Calendar) {
            calendar = (Calendar)data;
        }
        if (calendar == null) {
            return this.applyByteOrder(this.getReplaceValue());
        }
        calendar = (Calendar)calendar.clone();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (calendar != null) {
            if (StringUtils.equals((CharSequence)this.variant, (CharSequence)DEFAULT)) {
                int dayOfWeek = calendar.get(7);
                dayOfWeek = dayOfWeek == 1 ? 7 : dayOfWeek - 1;
                result = new byte[]{bcdType.encode(calendar.get(5))[0], bcdType.encode(calendar.get(2) + 1)[0], bcdType.encode(dayOfWeek)[0], bcdType.encode(calendar.get(1) % 100)[0]};
            } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)SHORT)) {
                result = new byte[]{bcdType.encode(calendar.get(5))[0], bcdType.encode(calendar.get(2) + 1)[0], bcdType.encode(calendar.get(1) % 100)[0]};
            } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)HEX)) {
                int dayOfWeek = calendar.get(7);
                dayOfWeek = dayOfWeek == 1 ? 7 : dayOfWeek - 1;
                result = new byte[]{charType.encode(calendar.get(5))[0], charType.encode(calendar.get(2) + 1)[0], charType.encode(dayOfWeek)[0], charType.encode(calendar.get(1) % 100)[0]};
            } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)HEX_SHORT)) {
                result = new byte[]{charType.encode(calendar.get(5))[0], charType.encode(calendar.get(2) + 1)[0], charType.encode(calendar.get(1) % 100)[0]};
            } else if (StringUtils.equals((CharSequence)this.variant, (CharSequence)DAYS)) {
                long millis = calendar.getTimeInMillis();
                calendar.clear();
                calendar.set(1900, 0, 1, 0, 0);
                long millis1900 = calendar.getTimeInMillis();
                BigDecimal days = new BigDecimal(millis - millis1900);
                days = days.divide(BigDecimal.valueOf(86400000L), 0, RoundingMode.HALF_UP);
                result = wordType.encode(days);
            }
        }
        return result;
    }

    public String toString() {
        return "EBusTypeDate [variant=" + this.variant + "]";
    }
}

