/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes;

import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.command.datatypes.ext.EBusTypeBytes;
import de.csdev.ebus.command.datatypes.ext.EBusTypeDate;
import de.csdev.ebus.command.datatypes.ext.EBusTypeDateTime;
import de.csdev.ebus.command.datatypes.ext.EBusTypeKWCrc;
import de.csdev.ebus.command.datatypes.ext.EBusTypeMultiWord;
import de.csdev.ebus.command.datatypes.ext.EBusTypeString;
import de.csdev.ebus.command.datatypes.ext.EBusTypeTime;
import de.csdev.ebus.command.datatypes.ext.EBusTypeVersion;
import de.csdev.ebus.command.datatypes.std.EBusTypeBCD;
import de.csdev.ebus.command.datatypes.std.EBusTypeBit;
import de.csdev.ebus.command.datatypes.std.EBusTypeByte;
import de.csdev.ebus.command.datatypes.std.EBusTypeChar;
import de.csdev.ebus.command.datatypes.std.EBusTypeData1b;
import de.csdev.ebus.command.datatypes.std.EBusTypeData1c;
import de.csdev.ebus.command.datatypes.std.EBusTypeData2b;
import de.csdev.ebus.command.datatypes.std.EBusTypeData2c;
import de.csdev.ebus.command.datatypes.std.EBusTypeFloat;
import de.csdev.ebus.command.datatypes.std.EBusTypeInteger;
import de.csdev.ebus.command.datatypes.std.EBusTypeNumber;
import de.csdev.ebus.command.datatypes.std.EBusTypeUnsignedNumber;
import de.csdev.ebus.command.datatypes.std.EBusTypeWord;
import de.csdev.ebus.utils.CollectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusTypeRegistry {
    private static final Logger logger = LoggerFactory.getLogger(EBusTypeRegistry.class);
    private Map<String, IEBusType<?>> types = null;

    public EBusTypeRegistry() throws EBusTypeException {
        this.init();
    }

    protected void init() throws EBusTypeException {
        this.types = new HashMap();
        this.add(EBusTypeBit.class);
        this.add(EBusTypeByte.class);
        this.add(EBusTypeChar.class);
        this.add(EBusTypeInteger.class);
        this.add(EBusTypeWord.class);
        this.add(EBusTypeNumber.class);
        this.add(EBusTypeUnsignedNumber.class);
        this.add(EBusTypeBCD.class);
        this.add(EBusTypeData1b.class);
        this.add(EBusTypeData1c.class);
        this.add(EBusTypeData2b.class);
        this.add(EBusTypeData2c.class);
        this.add(EBusTypeBytes.class);
        this.add(EBusTypeString.class);
        this.add(EBusTypeMultiWord.class);
        this.add(EBusTypeDateTime.class);
        this.add(EBusTypeDate.class);
        this.add(EBusTypeTime.class);
        this.add(EBusTypeVersion.class);
        this.add(EBusTypeFloat.class);
        this.add(EBusTypeKWCrc.class);
    }

    public <T> IEBusType<T> getType(String type, Map<String, Object> properties) {
        IEBusType<T> ebusType = this.getType(type);
        if (ebusType != null) {
            return ebusType.getInstance(properties);
        }
        return null;
    }

    public <T> IEBusType<T> getType(String type, Object ... propertiesArguments) {
        Map<String, Object> properties = CollectionUtils.createProperties(propertiesArguments);
        return this.getType(type, properties);
    }

    public <T> IEBusType<T> getType(String type) {
        IEBusType<?> eBusType = this.types.get(type);
        if (eBusType == null) {
            logger.warn("No eBUS data type with name {} !", (Object)type);
            return null;
        }
        return eBusType;
    }

    public <T> Set<String> getTypesNames() {
        return this.types.keySet();
    }

    public byte[] encode(String type, Object data) throws EBusTypeException {
        IEBusType<?> eBusType = this.types.get(type);
        if (eBusType == null) {
            logger.warn("No eBUS data type with name {} !", (Object)type);
            return null;
        }
        return eBusType.encode(data);
    }

    public <T> @Nullable T decode(@Nullable String type, byte @Nullable [] data) throws EBusTypeException {
        IEBusType<?> eBusType = this.types.get(type);
        if (eBusType == null) {
            logger.warn("No eBUS data type with name {} !", (Object)type);
            return null;
        }
        return (T)eBusType.decode(data);
    }

    public void add(Class<?> clazz) throws EBusTypeException {
        try {
            IEBusType newInstance = (IEBusType)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (newInstance == null) {
                throw new EBusTypeException(String.format("Unable to create a new instance for class %s", clazz.getName()));
            }
            newInstance.setTypesParent(this);
            for (String typeName : newInstance.getSupportedTypes()) {
                logger.trace("Add eBUS type {}", (Object)typeName);
                this.types.put(typeName, newInstance);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("error!", (Throwable)e);
        }
    }

    public String toString() {
        return "EBusTypeRegistry [types=" + this.types + "]";
    }
}

