/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command;

import de.csdev.ebus.cfg.EBusConfigurationReaderException;
import de.csdev.ebus.cfg.IEBusConfigurationReader;
import de.csdev.ebus.command.EBusCommandUtils;
import de.csdev.ebus.command.IEBusCommand;
import de.csdev.ebus.command.IEBusCommandCollection;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.EBusTypeRegistry;
import de.csdev.ebus.utils.EBusUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusCommandRegistry {
    private final Logger logger = LoggerFactory.getLogger(EBusCommandRegistry.class);
    private @NonNull Map<String, IEBusCommandCollection> collections = new HashMap<String, IEBusCommandCollection>();
    private @NonNull EBusTypeRegistry typeRegistry;
    private @NonNull IEBusConfigurationReader reader;

    public IEBusConfigurationReader getConfigurationReader() {
        return this.reader;
    }

    public EBusCommandRegistry(Class<? extends IEBusConfigurationReader> readerClass) {
        this(readerClass, false);
    }

    public EBusCommandRegistry(Class<? extends IEBusConfigurationReader> readerClass, boolean loadBuildInCommands) {
        try {
            this.typeRegistry = new EBusTypeRegistry();
            this.reader = readerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.reader.setEBusTypes(this.typeRegistry);
            if (loadBuildInCommands) {
                this.loadBuildInCommandCollections();
            }
        }
        catch (EBusConfigurationReaderException | EBusTypeException | IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void loadBuildInCommandCollections() throws EBusConfigurationReaderException, IOException {
        List<@NonNull IEBusCommandCollection> loadBuildInConfigurations = this.reader.loadBuildInConfigurationCollections();
        if (!loadBuildInConfigurations.isEmpty()) {
            for (IEBusCommandCollection collection : loadBuildInConfigurations) {
                this.addCommandCollection(collection);
            }
        }
    }

    public void loadCommandCollection(@NonNull URL url) throws EBusConfigurationReaderException, IOException {
        Objects.requireNonNull(url);
        this.addCommandCollection(this.reader.loadConfigurationCollection(url));
    }

    public void loadCommandCollectionBundle(@NonNull URL url) throws EBusConfigurationReaderException, IOException {
        Objects.requireNonNull(url);
        for (IEBusCommandCollection collection : this.reader.loadConfigurationCollectionBundle(url)) {
            this.addCommandCollection(collection);
        }
    }

    public void addCommandCollection(IEBusCommandCollection collection) {
        if (collection != null) {
            this.collections.put(collection.getId(), collection);
        }
    }

    public @NonNull List<IEBusCommandMethod> find(byte @NonNull [] data) {
        Objects.requireNonNull(data);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return this.find(buffer);
    }

    public @NonNull List<IEBusCommandMethod> find(@NonNull ByteBuffer data) {
        Objects.requireNonNull(data);
        ArrayList<IEBusCommandMethod> result = new ArrayList<IEBusCommandMethod>();
        for (IEBusCommandCollection collection : this.collections.values()) {
            for (IEBusCommand command : collection.getCommands()) {
                for (IEBusCommandMethod commandChannel : command.getCommandMethods()) {
                    if (commandChannel == null || !this.matchesCommand(commandChannel, data)) continue;
                    result.add(commandChannel);
                }
            }
        }
        return result;
    }

    public @Nullable IEBusCommand getCommandById(@NonNull String collectionId, @NonNull String id) {
        Objects.requireNonNull(collectionId);
        Objects.requireNonNull(id);
        IEBusCommandCollection collection = this.collections.get(collectionId);
        if (collection == null) {
            return null;
        }
        return collection.getCommand(id);
    }

    public @Nullable IEBusCommandCollection getCommandCollection(@NonNull String id) {
        Objects.requireNonNull(id);
        return this.collections.get(id);
    }

    public @NonNull List<@NonNull IEBusCommandCollection> getCommandCollections() {
        return Collections.unmodifiableList(new ArrayList<IEBusCommandCollection>(this.collections.values()));
    }

    public @Nullable IEBusCommandMethod getCommandMethodById(@NonNull String collectionId, @NonNull String id, @NonNull IEBusCommandMethod.Method type) {
        IEBusCommand command = this.getCommandById(collectionId, id);
        if (command != null) {
            return command.getCommandMethod(type);
        }
        return null;
    }

    public EBusTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public boolean matchesCommand(@NonNull IEBusCommandMethod command, @NonNull ByteBuffer data) {
        boolean isInvalidMasterSlave;
        Byte sourceAddress = (Byte)ObjectUtils.defaultIfNull((Object)command.getSourceAddress(), (Object)0);
        Byte targetAddress = (Byte)ObjectUtils.defaultIfNull((Object)command.getDestinationAddress(), (Object)0);
        boolean isInvalidBroadcast = data.get(1) == -2 && command.getType() != IEBusCommandMethod.Type.BROADCAST;
        boolean isInvalidMasterMaster = EBusUtils.isMasterAddress(data.get(1)) && command.getType() != IEBusCommandMethod.Type.MASTER_MASTER;
        boolean bl = isInvalidMasterSlave = EBusUtils.isSlaveAddress(data.get(1)) && command.getType() != IEBusCommandMethod.Type.MASTER_SLAVE;
        if (isInvalidBroadcast || isInvalidMasterMaster || isInvalidMasterSlave) {
            return false;
        }
        try {
            byte b;
            ByteBuffer masterTelegram = EBusCommandUtils.buildMasterTelegram(command, sourceAddress, targetAddress, null, true);
            ByteBuffer mask = command.getMasterTelegramMask();
            for (int i = 0; i < mask.limit() && ((b = mask.get(i)) != -1 || masterTelegram.get(i) == data.get(i)); ++i) {
                if (i != mask.limit() - 1) continue;
                if (command.getType() == IEBusCommandMethod.Type.MASTER_SLAVE) {
                    if (!EBusUtils.isSlaveAddress(data.get(1))) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Data for matching command configuration \"{}\" is not a master-slave telegram as expected!", (Object)EBusCommandUtils.getFullId(command));
                            this.logger.warn("DATA: {}", (Object)EBusUtils.toHexDumpString(data));
                        }
                        return false;
                    }
                    if (command.getSlaveTypes() == null) {
                        this.logger.debug("Warning: Master-Slave command \"{}\" has no slave configuration defined! Skip advanced match checks ...", (Object)EBusCommandUtils.getFullId(command));
                    } else {
                        byte slaveLen;
                        int computedSlaveLen = EBusCommandUtils.getSlaveDataLength(command);
                        int slaveLenPos = masterTelegram.limit() + 1;
                        if (slaveLenPos <= data.limit() && (slaveLen = data.get(slaveLenPos)) != computedSlaveLen) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Skip matching command due to invalid response data length ... [{}]", (Object)EBusCommandUtils.getFullId(command));
                                this.logger.trace("DATA: {}", (Object)EBusUtils.toHexDumpString(data));
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("DATA: {}", (Object)EBusUtils.toHexDumpString(data));
            this.logger.error("CMD : {}, {}", (Object)command.getParent().getParentCollection().getId(), (Object)command.getParent().getId());
            this.logger.error("error!", (Throwable)e);
        }
        return false;
    }

    public void clear() {
        this.reader.clear();
        this.collections.clear();
    }

    public String toString() {
        return "EBusCommandRegistry [collections=" + this.collections + "]";
    }
}

