/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.cfg.std;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import de.csdev.ebus.cfg.std.dto.EBusValueDTO;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusValueJsonDeserializer
implements JsonDeserializer<List<EBusValueDTO>> {
    private final Logger logger = LoggerFactory.getLogger(EBusValueJsonDeserializer.class);

    public List<EBusValueDTO> deserialize(JsonElement jElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray asJsonArray = jElement.getAsJsonArray();
        ArrayList<EBusValueDTO> result = new ArrayList<EBusValueDTO>();
        ArrayList<String> fields = new ArrayList<String>();
        for (Field field : EBusValueDTO.class.getDeclaredFields()) {
            SerializedName annotation = field.getAnnotation(SerializedName.class);
            if (annotation != null) {
                fields.add(annotation.value());
                continue;
            }
            fields.add(field.getName());
        }
        for (JsonElement jsonElement : asJsonArray) {
            JsonObject jObject = jsonElement.getAsJsonObject();
            EBusValueDTO valueDTO = (EBusValueDTO)context.deserialize((JsonElement)jObject, EBusValueDTO.class);
            for (Map.Entry entry : jObject.entrySet()) {
                if (fields.contains(entry.getKey())) continue;
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    JsonPrimitive primitive = (JsonPrimitive)entry.getValue();
                    if (primitive.isNumber()) {
                        valueDTO.setProperty((String)entry.getKey(), primitive.getAsBigDecimal());
                        continue;
                    }
                    if (primitive.isBoolean()) {
                        valueDTO.setProperty((String)entry.getKey(), primitive.getAsBoolean());
                        continue;
                    }
                    if (!primitive.isString()) continue;
                    valueDTO.setProperty((String)entry.getKey(), primitive.getAsString());
                    continue;
                }
                valueDTO.setProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            result.add(valueDTO);
        }
        return result;
    }
}

