/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.utils;

import de.csdev.ebus.utils.EBusUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmulatorCapture {
    private static final Logger logger = LoggerFactory.getLogger(EmulatorCapture.class);
    protected long referenceTime = System.currentTimeMillis();
    protected PrintWriter writer;

    public EmulatorCapture(File outputFile) {
        try {
            this.writer = new PrintWriter(outputFile, "UTF-8");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            logger.error("error!", (Throwable)e);
        }
    }

    public void write(byte[] buffer, int len) {
        byte[] copyOf = Arrays.copyOf(buffer, len);
        this.write(copyOf);
    }

    public void write(byte[] buffer, int from, int len) {
        byte[] copyOf = Arrays.copyOfRange(buffer, from, len);
        this.write(copyOf);
    }

    public void write(byte[] buffer) {
        this.writer.printf("%09d", System.currentTimeMillis() - this.referenceTime);
        this.writer.print(" - ");
        this.writer.println(EBusUtils.toHexDumpString(buffer).toString());
        this.writer.flush();
        this.referenceTime = System.currentTimeMillis();
    }

    public void close() {
        this.writer.flush();
        this.writer.close();
    }
}

