/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.service.device;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.csdev.ebus.service.device.EBusDevice;
import de.csdev.ebus.service.device.IEBusDeviceTableListener;
import de.csdev.ebus.utils.EBusUtils;
import de.csdev.ebus.utils.NumberUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusDeviceTable {
    private static final Logger logger = LoggerFactory.getLogger(EBusDeviceTable.class);
    private Map<Byte, EBusDevice> deviceTable;
    private final List<IEBusDeviceTableListener> listeners = new CopyOnWriteArrayList<IEBusDeviceTableListener>();
    private Map<String, String> vendors;
    private byte ownAddress;

    public EBusDeviceTable() {
        this.deviceTable = new HashMap<Byte, EBusDevice>();
    }

    public void dispose() {
        this.listeners.clear();
        if (this.deviceTable != null) {
            this.deviceTable.clear();
        }
        if (this.vendors != null) {
            this.vendors.clear();
        }
    }

    public void setOwnAddress(byte ownAddress) {
        this.ownAddress = ownAddress;
        EBusDevice d = new EBusDevice(ownAddress, this);
        this.deviceTable.put(d.getMasterAddress(), d);
    }

    public String getManufacturerName(byte vendorCode) {
        if (this.vendors == null) {
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            InputStream inputStream = this.getClass().getResourceAsStream("/manufactures.json");
            this.vendors = (Map)gson.fromJson((Reader)new InputStreamReader(inputStream), type);
        }
        if (this.vendors == null) {
            logger.warn("Unable to load manufactures.json!");
            return null;
        }
        return this.vendors.get(EBusUtils.toHexDumpString(vendorCode));
    }

    public void updateDevice(byte address, Map<@NonNull String, @Nullable Object> data) {
        boolean newDevice = false;
        boolean updatedDevice = false;
        byte addr = address;
        if (addr == -2) {
            return;
        }
        if (EBusUtils.isMasterAddress(addr)) {
            Byte result = EBusUtils.getSlaveAddress(addr);
            if (result == null) {
                throw new IllegalArgumentException(String.format("Given slave address %s is invalid!", EBusUtils.toHexDumpString(addr)));
            }
            addr = result;
        }
        if (addr == this.ownAddress) {
            return;
        }
        EBusDevice device = this.deviceTable.get(addr);
        if (device == null) {
            device = new EBusDevice(addr, this);
            device.setLastActivity(System.currentTimeMillis());
            this.deviceTable.put(addr, device);
            newDevice = true;
        }
        device.setLastActivity(System.currentTimeMillis());
        if (data != null && !data.isEmpty()) {
            BigDecimal obj2;
            Object value;
            Object obj;
            if (data.containsKey("device_id") && (obj = data.get("device_id")) != null && !obj.equals(device.getDeviceId()) && obj instanceof byte[]) {
                device.setDeviceId((byte[])obj);
                updatedDevice = true;
            }
            if ((value = data.get("hardware_version")) != null && (obj2 = NumberUtils.toBigDecimal(value)) != null && !ObjectUtils.equals((Object)obj2, (Object)device.getHardwareVersion())) {
                device.setHardwareVersion(obj2);
                updatedDevice = true;
            }
            if ((value = data.get("software_version")) != null && (obj2 = NumberUtils.toBigDecimal(value)) != null && !ObjectUtils.equals((Object)obj2, (Object)device.getSoftwareVersion())) {
                device.setSoftwareVersion(obj2);
                updatedDevice = true;
            }
            if ((value = data.get("vendor")) != null && (obj2 = NumberUtils.toBigDecimal(value)) != null && !ObjectUtils.equals((Object)obj2.byteValue(), (Object)device.getManufacturer())) {
                int intValue = obj2.intValue();
                device.setManufacturer((byte)intValue);
                updatedDevice = true;
            }
        }
        if (newDevice) {
            this.fireOnDeviceUpdate(IEBusDeviceTableListener.TYPE.NEW, device);
        } else if (updatedDevice) {
            this.fireOnDeviceUpdate(IEBusDeviceTableListener.TYPE.UPDATE, device);
        } else {
            this.fireOnDeviceUpdate(IEBusDeviceTableListener.TYPE.UPDATE_ACTIVITY, device);
        }
    }

    public Collection<EBusDevice> getDeviceTable() {
        return Collections.unmodifiableCollection(this.deviceTable.values());
    }

    private void fireOnDeviceUpdate(@NonNull IEBusDeviceTableListener.TYPE type, @NonNull EBusDevice device) {
        for (IEBusDeviceTableListener listener : this.listeners) {
            try {
                listener.onEBusDeviceUpdate(type, device);
            }
            catch (Exception e) {
                logger.error("Error while firing onEBusDeviceUpdate events!", (Throwable)e);
            }
        }
    }

    public EBusDevice getOwnDevice() {
        return this.deviceTable.get(this.ownAddress);
    }

    public void addEBusDeviceTableListener(IEBusDeviceTableListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public boolean removeEBusDeviceTableListener(IEBusDeviceTableListener listener) {
        Objects.requireNonNull(listener);
        return this.listeners.remove(listener);
    }
}

