/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core.connection;

import de.csdev.ebus.core.connection.AbstractEBusConnection;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusTCPConnection
extends AbstractEBusConnection {
    private static final Logger logger = LoggerFactory.getLogger(EBusTCPConnection.class);
    private Socket socket;
    private String hostname;
    private int port;

    public EBusTCPConnection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public boolean open() throws IOException {
        try {
            this.socket = new Socket(this.hostname, this.port);
            this.socket.setSoTimeout(20000);
            this.socket.setKeepAlive(true);
            this.socket.setTcpNoDelay(true);
            this.socket.setTrafficClass(16);
            this.socket.setReceiveBufferSize(1);
            this.socket.setSendBufferSize(1);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (ConnectException e) {
            logger.warn("Connection error: Connection refused {}:{}", (Object)this.hostname, (Object)this.port);
        }
        catch (UnknownHostException e) {
            logger.warn("Connection error: Unknown host {}:{}", (Object)this.hostname, (Object)this.port);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean close() throws IOException {
        boolean close = super.close();
        if (close) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            return true;
        }
        return false;
    }
}

