/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core.connection;

import de.csdev.ebus.core.connection.IEBusConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEBusConnection
implements IEBusConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEBusConnection.class);
    protected OutputStream outputStream;
    protected InputStream inputStream;

    @Override
    public boolean close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
        IOUtils.closeQuietly((InputStream)this.inputStream);
        IOUtils.closeQuietly((OutputStream)this.outputStream);
        this.inputStream = null;
        this.outputStream = null;
        return true;
    }

    @Override
    public boolean isOpen() throws IOException {
        return this.inputStream != null;
    }

    @Override
    public int readBytes(byte[] buffer) throws IOException {
        return this.inputStream.read(buffer);
    }

    @Override
    public int readByte(boolean lowLatency) throws IOException {
        return this.inputStream.read();
    }

    @Override
    public boolean isReceiveBufferEmpty() throws IOException {
        return this.inputStream.available() == 0;
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.outputStream.write(b);
        this.outputStream.flush();
    }

    @Override
    public void reset() throws IOException {
        int available = this.inputStream.available();
        if (available > 0) {
            logger.debug("InputBuffer is not empty before sending: {} byte(s) waiting !", (Object)available);
        }
        this.inputStream.skip(available);
    }
}

