/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core;

import de.csdev.ebus.command.EBusCommandUtils;
import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.utils.EBusUtils;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusReceiveStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(EBusReceiveStateMachine.class);
    private ByteBuffer bb = ByteBuffer.allocate(50);
    private byte crc = 0;
    private boolean isEscapedByte = false;
    private int len = 0;
    private State state = State.UNKNOWN;
    private boolean telegramAvailable = false;

    private void fireTelegramAvailable() {
        logger.trace("fireTelegramAvailable ...");
        this.telegramAvailable = true;
    }

    public void updateBytes(byte @NonNull [] data) throws EBusDataException {
        this.update((byte)-86);
        for (byte b : data) {
            this.update(b);
        }
    }

    public State getState() {
        return this.state;
    }

    public byte getCurrentCrc() {
        return this.crc;
    }

    public int getRemainDataLength() {
        return this.len;
    }

    public byte @NonNull [] getTelegramData() {
        return EBusUtils.toByteArray(this.bb);
    }

    public boolean isWaitingForSlaveAnswer() {
        return this.state == State.CRC1 && this.bb.get(1) != -2;
    }

    public boolean isReceivingTelegram() {
        return this.state != State.UNKNOWN && this.state != State.SYN;
    }

    public boolean isSync() {
        return this.state == State.SYN;
    }

    public boolean isTelegramAvailable() {
        return this.telegramAvailable;
    }

    public boolean isWaitingForMasterACK() {
        return this.state.equals((Object)State.CRC2);
    }

    public boolean isWaitingForMasterSYN() {
        if (this.state.equals((Object)State.CRC1) && this.bb.get(1) == -2) {
            return true;
        }
        if (this.state.equals((Object)State.ACK1) && EBusUtils.isMasterAddress(this.bb.get(1))) {
            return true;
        }
        return this.state.equals((Object)State.ACK2);
    }

    public void reset() {
        this.reset(false);
    }

    private void reset(boolean ignoreState) {
        this.len = 0;
        this.crc = 0;
        this.isEscapedByte = false;
        this.telegramAvailable = false;
        this.bb.clear();
        if (!ignoreState) {
            this.setState(State.UNKNOWN);
        }
    }

    private void setState(State newState) {
        if (logger.isTraceEnabled()) {
            logger.trace("Update state from {} to {}", (Object)this.state.name(), (Object)newState.name());
        }
        this.state = newState;
    }

    private void throwExceptionIfSYN(byte data) throws EBusDataException {
        if (data == -86) {
            this.bb.put(data);
            throw new EBusDataException("Received SYN byte while receiving telegram!", EBusDataException.EBusError.INVALID_SYN, this.bb);
        }
    }

    public String toDumpString() {
        return EBusUtils.toHexDumpString(this.bb).toString();
    }

    public void update(byte dataByte) throws EBusDataException {
        byte data = dataByte;
        try {
            if (!this.bb.hasRemaining()) {
                logger.warn("Input buffer full, reset!");
                throw new EBusDataException("Input buffer full, reset!", EBusDataException.EBusError.BUFFER_FULL, this.bb);
            }
            switch (this.state) {
                case UNKNOWN: {
                    if (data == -86) {
                        this.setState(State.SYN);
                    }
                    break;
                }
                case SYN: {
                    if (EBusUtils.isMasterAddress(data)) {
                        this.reset(true);
                        this.bb.put(data);
                        this.crc = EBusUtils.crc8_tab(data, (byte)0);
                        this.setState(State.SRC_ADDR);
                        break;
                    }
                    if (data == -86) {
                        logger.trace("Auto-SYN byte received");
                        break;
                    }
                    throw new EBusDataException("Telegram starts with an invalid source address! " + EBusUtils.toHexDumpString(data), EBusDataException.EBusError.INVALID_SOURCE_ADDRESS, this.bb);
                }
                case SRC_ADDR: {
                    this.throwExceptionIfSYN(data);
                    this.bb.put(data);
                    this.crc = EBusUtils.crc8_tab(data, this.crc);
                    this.setState(State.TGT_ADDR);
                    break;
                }
                case TGT_ADDR: {
                    this.throwExceptionIfSYN(data);
                    this.bb.put(data);
                    this.crc = EBusUtils.crc8_tab(data, this.crc);
                    this.setState(State.PRIMARY_CMD);
                    break;
                }
                case PRIMARY_CMD: {
                    this.throwExceptionIfSYN(data);
                    this.bb.put(data);
                    this.crc = EBusUtils.crc8_tab(data, this.crc);
                    this.setState(State.SECONDARY_CMD);
                    break;
                }
                case SECONDARY_CMD: {
                    this.throwExceptionIfSYN(data);
                    if (data > 16) {
                        throw new EBusDataException("Master Data Length too large!", EBusDataException.EBusError.INVALID_MASTER_LEN, this.bb);
                    }
                    this.len = data;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Master data length: {}", (Object)this.len);
                    }
                    this.bb.put(data);
                    this.crc = EBusUtils.crc8_tab(data, this.crc);
                    this.setState(this.len == 0 ? State.DATA1 : State.LENGTH1);
                    break;
                }
                case LENGTH1: {
                    this.throwExceptionIfSYN(data);
                    this.crc = EBusUtils.crc8_tab(data, this.crc);
                    if (data == -87) {
                        this.isEscapedByte = true;
                    } else {
                        if (this.isEscapedByte) {
                            data = EBusCommandUtils.unescapeSymbol(data);
                            this.isEscapedByte = false;
                        }
                        this.bb.put(data);
                        --this.len;
                    }
                    if (this.len == 0) {
                        this.setState(State.DATA1);
                        break;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Data length: {}", (Object)this.len);
                    }
                    break;
                }
                case DATA1: {
                    this.throwExceptionIfSYN(data);
                    if (!this.isEscapedByte && data == -87) {
                        this.isEscapedByte = true;
                        break;
                    }
                    if (this.isEscapedByte) {
                        data = EBusCommandUtils.unescapeSymbol(data);
                        this.isEscapedByte = false;
                    }
                    this.bb.put(data);
                    if (data == this.crc) {
                        logger.trace("Master CRC correct");
                        this.setState(State.CRC1);
                        break;
                    }
                    throw new EBusDataException("Master CRC invalid! IS:" + EBusUtils.toHexDumpString(this.crc) + " SHOULD:" + EBusUtils.toHexDumpString(data), EBusDataException.EBusError.MASTER_CRC_INVALID, this.bb);
                }
                case CRC1: {
                    if (data == -86) {
                        if (this.bb.get(1) == -2) {
                            logger.trace("broadcast end");
                            this.bb.put(data);
                            this.setState(State.SYN);
                            this.fireTelegramAvailable();
                            return;
                        }
                        throw new EBusDataException("No response from slave! " + EBusUtils.toHexDumpString(data), EBusDataException.EBusError.NO_SLAVE_RESPONSE, this.bb);
                    }
                    this.bb.put(data);
                    if (data == 0) {
                        this.setState(State.ACK1);
                        break;
                    }
                    if (data == -1) {
                        throw new EBusDataException("Slave answered with FAIL ACK!", EBusDataException.EBusError.SLAVE_ACK_FAIL, this.bb);
                    }
                    throw new EBusDataException("Slave answered with " + EBusUtils.toHexDumpString(data), EBusDataException.EBusError.UNEXPECTED_RESPONSE, this.bb);
                }
                case ACK1: {
                    if (data == -86 && EBusUtils.isMasterAddress(this.bb.get(1))) {
                        logger.trace("master-master end");
                        this.bb.put(data);
                        this.setState(State.SYN);
                        this.fireTelegramAvailable();
                        return;
                    }
                    this.throwExceptionIfSYN(data);
                    this.bb.put(data);
                    this.crc = EBusUtils.crc8_tab(data, (byte)0);
                    if (data > 16) {
                        throw new EBusDataException("Slave Data Length too large!", EBusDataException.EBusError.INVALID_SLAVE_LEN, this.bb);
                    }
                    this.len = data;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Slave data length: {}", (Object)this.len);
                    }
                    this.setState(this.len == 0 ? State.CRC2 : State.LENGTH2);
                    break;
                }
                case LENGTH2: {
                    this.throwExceptionIfSYN(data);
                    this.crc = EBusUtils.crc8_tab(data, this.crc);
                    if (data == -87) {
                        this.isEscapedByte = true;
                    } else {
                        if (this.isEscapedByte) {
                            data = EBusCommandUtils.unescapeSymbol(data);
                            this.isEscapedByte = false;
                        }
                        this.bb.put(data);
                        --this.len;
                    }
                    if (this.len == 0) {
                        this.setState(State.DATA2);
                        break;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Data length: {}", (Object)this.len);
                    }
                    break;
                }
                case DATA2: {
                    this.throwExceptionIfSYN(data);
                    if (!this.isEscapedByte && data == -87) {
                        this.isEscapedByte = true;
                        break;
                    }
                    if (this.isEscapedByte) {
                        data = EBusCommandUtils.unescapeSymbol(data);
                        this.isEscapedByte = false;
                    }
                    this.bb.put(data);
                    if (data == this.crc) {
                        this.setState(State.CRC2);
                        break;
                    }
                    throw new EBusDataException("Slave CRC invalid! IS:" + EBusUtils.toHexDumpString(this.crc) + " SHOULD:" + EBusUtils.toHexDumpString(data), EBusDataException.EBusError.SLAVE_CRC_INVALID, this.bb);
                }
                case CRC2: {
                    this.bb.put(data);
                    if (data == 0) {
                        this.setState(State.ACK2);
                        break;
                    }
                    if (data == -86) {
                        throw new EBusDataException("No slave response!", EBusDataException.EBusError.NO_SLAVE_RESPONSE, this.bb);
                    }
                    if (data == -1) {
                        throw new EBusDataException("Master answered with FAIL ACK!", EBusDataException.EBusError.MASTER_ACK_FAIL, this.bb);
                    }
                    throw new EBusDataException("Master answered with " + EBusUtils.toHexDumpString(data), EBusDataException.EBusError.UNEXPECTED_RESPONSE, this.bb);
                }
                case ACK2: {
                    this.setState(State.SYN);
                    this.fireTelegramAvailable();
                    break;
                }
                default: {
                    throw new EBusDataException("Unknown state in eBus state machine!");
                }
            }
        }
        catch (EBusDataException e) {
            this.reset();
            throw e;
        }
    }

    public static enum State {
        UNKNOWN,
        SYN,
        SRC_ADDR,
        TGT_ADDR,
        PRIMARY_CMD,
        SECONDARY_CMD,
        LENGTH1,
        DATA1,
        CRC1,
        ACK1,
        LENGTH2,
        DATA2,
        CRC2,
        ACK2;

    }
}

