/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.std.AbstractEBusTypeNumber;
import de.csdev.ebus.utils.EBusUtils;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import org.eclipse.jdt.annotation.Nullable;

public class EBusTypeData2c
extends AbstractEBusTypeNumber {
    public static String TYPE_DATA2C = "data2c";
    private static String[] supportedTypes = new String[]{TYPE_DATA2C};

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        return 2;
    }

    @Override
    public BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        BigDecimal decodeInt = super.decodeInt(data);
        return decodeInt.divide(BigDecimal.valueOf(16L));
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal b = NumberUtils.toBigDecimal(data);
        if (b == null) {
            throw new EBusTypeException("Unable to convert input data to number!");
        }
        return super.encodeInt(b.multiply(BigDecimal.valueOf(16L)));
    }

    public String toString() {
        return "EBusTypeData2c [replaceValue=" + EBusUtils.toHexDumpString(this.getReplaceValue()).toString() + "]";
    }
}

