/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.std;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.utils.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractEBusTypeUnsignedNumber
extends EBusAbstractType<BigDecimal> {
    @Override
    public BigDecimal decodeInt(byte @Nullable [] data) throws EBusTypeException {
        byte[] clone = ArrayUtils.clone((byte[])data);
        ArrayUtils.reverse((byte[])clone);
        return new BigDecimal(new BigInteger(1, clone));
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        BigDecimal b = NumberUtils.toBigDecimal(data == null ? Integer.valueOf(0) : data);
        if (b == null) {
            throw new EBusTypeException("Unable to convert input data to number!");
        }
        long l = b.longValue() & Long.MAX_VALUE;
        int length = this.getTypeLength();
        byte[] result = new byte[length];
        for (int i = 0; i <= length - 1; ++i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }
}

