/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.ext;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.command.datatypes.std.EBusTypeBCD;
import de.csdev.ebus.command.datatypes.std.EBusTypeChar;
import de.csdev.ebus.command.datatypes.std.EBusTypeUnsignedNumber;
import de.csdev.ebus.command.datatypes.std.EBusTypeWord;
import de.csdev.ebus.utils.EBusDateTime;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.Nullable;

public class EBusTypeTime
extends EBusAbstractType<EBusDateTime> {
    public static String TYPE_TIME = "time";
    public static String DEFAULT = "std";
    public static String HEX = "hex";
    public static String SHORT = "short";
    public static String HEX_SHORT = "hex_short";
    public static String MINUTES = "minutes";
    public static String MINUTES_SHORT = "minutes_short";
    private static String[] supportedTypes = new String[]{TYPE_TIME};
    public static String MINUTE_MULTIPLIER = "minuteMultiplier";
    private String variant = DEFAULT;
    private BigDecimal minuteMultiplier = BigDecimal.valueOf(1L);

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public int getTypeLength() {
        if (this.variant.equals(DEFAULT)) {
            return 3;
        }
        if (this.variant.equals(HEX)) {
            return 3;
        }
        if (this.variant.equals(SHORT)) {
            return 2;
        }
        if (this.variant.equals(HEX_SHORT)) {
            return 2;
        }
        if (this.variant.equals(MINUTES)) {
            return 2;
        }
        if (this.variant.equals(MINUTES_SHORT)) {
            return 1;
        }
        return 0;
    }

    @Override
    public EBusDateTime decodeInt(byte @Nullable [] data) throws EBusTypeException {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar calendar = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        BigDecimal second = null;
        BigDecimal minute = null;
        BigDecimal hour = null;
        if (data.length != this.getTypeLength()) {
            throw new EBusTypeException("Input byte array must have a length of %d bytes!", this.getTypeLength());
        }
        if (StringUtils.equals((String)this.variant, (String)SHORT)) {
            IEBusType bcdType = this.types.getType(EBusTypeBCD.TYPE_BCD);
            minute = (BigDecimal)bcdType.decode(new byte[]{data[0]});
            hour = (BigDecimal)bcdType.decode(new byte[]{data[1]});
        } else if (StringUtils.equals((String)this.variant, (String)DEFAULT)) {
            IEBusType bcdType = this.types.getType(EBusTypeBCD.TYPE_BCD);
            second = (BigDecimal)bcdType.decode(new byte[]{data[0]});
            minute = (BigDecimal)bcdType.decode(new byte[]{data[1]});
            hour = (BigDecimal)bcdType.decode(new byte[]{data[2]});
        } else if (StringUtils.equals((String)this.variant, (String)HEX)) {
            IEBusType charType = this.types.getType(EBusTypeChar.TYPE_CHAR);
            second = (BigDecimal)charType.decode(new byte[]{data[0]});
            minute = (BigDecimal)charType.decode(new byte[]{data[1]});
            hour = (BigDecimal)charType.decode(new byte[]{data[2]});
        } else if (StringUtils.equals((String)this.variant, (String)HEX_SHORT)) {
            IEBusType charType = this.types.getType(EBusTypeChar.TYPE_CHAR);
            minute = (BigDecimal)charType.decode(new byte[]{data[0]});
            hour = (BigDecimal)charType.decode(new byte[]{data[1]});
        } else if (StringUtils.equals((String)this.variant, (String)MINUTES) || StringUtils.equals((String)this.variant, (String)MINUTES_SHORT)) {
            BigDecimal minutesSinceMidnight = null;
            if (StringUtils.equals((String)this.variant, (String)MINUTES_SHORT)) {
                IEBusType type = this.types.getType(EBusTypeUnsignedNumber.TYPE_UNUMBER, "length", 1);
                minutesSinceMidnight = (BigDecimal)type.decode(data);
            } else {
                IEBusType type = this.types.getType(EBusTypeUnsignedNumber.TYPE_UNUMBER, "length", 2);
                minutesSinceMidnight = (BigDecimal)type.decode(data);
            }
            if (minutesSinceMidnight == null) {
                throw new EBusTypeException("Unable to computed minutes since midnight!");
            }
            if ((minutesSinceMidnight = minutesSinceMidnight.multiply(this.minuteMultiplier)).intValue() > 1440) {
                throw new EBusTypeException("Value 'minutes since midnight' to large!");
            }
            ((Calendar)calendar).add(12, minutesSinceMidnight.intValue());
        }
        if (second != null) {
            calendar.set(13, second.intValue());
        }
        if (minute != null) {
            calendar.set(12, minute.intValue());
        }
        if (hour != null) {
            calendar.set(11, hour.intValue());
        }
        return new EBusDateTime(calendar, true, false);
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        IEBusType bcdType = this.types.getType(EBusTypeBCD.TYPE_BCD);
        IEBusType wordType = this.types.getType(EBusTypeWord.TYPE_WORD);
        IEBusType charType = this.types.getType(EBusTypeChar.TYPE_CHAR);
        Calendar calendar = null;
        byte[] result = new byte[this.getTypeLength()];
        if (data instanceof EBusDateTime) {
            calendar = ((EBusDateTime)data).getCalendar();
        } else if (data instanceof Calendar) {
            calendar = (Calendar)data;
        }
        if (calendar == null) {
            return this.applyByteOrder(this.getReplaceValue());
        }
        calendar = (Calendar)calendar.clone();
        calendar.set(1970, 0, 1);
        if (calendar != null) {
            if (StringUtils.equals((String)this.variant, (String)DEFAULT)) {
                result = new byte[]{bcdType.encode(calendar.get(13))[0], bcdType.encode(calendar.get(12))[0], bcdType.encode(calendar.get(11))[0]};
            } else if (StringUtils.equals((String)this.variant, (String)SHORT)) {
                result = new byte[]{bcdType.encode(calendar.get(12))[0], bcdType.encode(calendar.get(11))[0]};
            } else if (StringUtils.equals((String)this.variant, (String)HEX)) {
                result = new byte[]{charType.encode(calendar.get(13))[0], charType.encode(calendar.get(12))[0], charType.encode(calendar.get(11))[0]};
            } else if (StringUtils.equals((String)this.variant, (String)HEX_SHORT)) {
                result = new byte[]{charType.encode(calendar.get(12))[0], charType.encode(calendar.get(11))[0]};
            } else if (StringUtils.equals((String)this.variant, (String)MINUTES) || StringUtils.equals((String)this.variant, (String)MINUTES_SHORT)) {
                long millis = calendar.getTimeInMillis();
                calendar.clear();
                calendar.set(1970, 0, 1, 0, 0, 0);
                calendar.set(14, 0);
                long millisMidnight = calendar.getTimeInMillis();
                BigDecimal minutes = new BigDecimal(millis - millisMidnight);
                minutes = minutes.divide(BigDecimal.valueOf(60000L), 0, RoundingMode.HALF_UP);
                minutes = minutes.divide(this.minuteMultiplier, 0, RoundingMode.HALF_UP);
                result = StringUtils.equals((String)this.variant, (String)MINUTES_SHORT) ? charType.encode(minutes) : wordType.encode(minutes);
            }
        }
        return result;
    }

    public String toString() {
        return "EBusTypeTime [" + (this.variant != null ? "variant=" + this.variant + ", " : "") + "minuteMultiplier=" + this.minuteMultiplier + "]";
    }
}

