/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.ext;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.IEBusComplexType;
import de.csdev.ebus.utils.EBusUtils;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.Nullable;

public class EBusTypeKWCrc
extends EBusAbstractType<Byte>
implements IEBusComplexType<Byte> {
    public static String TYPE_KW_CRC = "kw-crc";
    public static String POS = "pos";
    public static int pos = 0;
    private static String[] supportedTypes = new String[]{TYPE_KW_CRC};

    public EBusTypeKWCrc() {
        this.replaceValue = new byte[]{-52};
    }

    @Override
    public int getTypeLength() {
        return 1;
    }

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    @Override
    public Byte decodeInt(byte @Nullable [] data) {
        throw new RuntimeException("Not implemented by EBusTypeKWCrc!");
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) {
        throw new RuntimeException("Not implemented by EBusTypeKWCrc!");
    }

    @Override
    public Byte decodeComplex(byte[] rawData, int pos) throws EBusTypeException {
        return (byte)-52;
    }

    @Override
    public byte[] encodeComplex(Object data) throws EBusTypeException {
        byte[] bytesData = null;
        if (data instanceof ByteBuffer) {
            bytesData = EBusUtils.toByteArray((ByteBuffer)data);
        } else if (data instanceof byte[]) {
            bytesData = (byte[])data;
        }
        if (bytesData != null) {
            byte b = 0;
            for (int i = pos + 1; i < bytesData.length; ++i) {
                if (i == pos) continue;
                b = EBusUtils.crc8(bytesData[i], b, (byte)92);
            }
            return new byte[]{b};
        }
        return new byte[]{-52};
    }

    public String toString() {
        return "EBusTypeKWCrc []";
    }
}

