/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command.datatypes.ext;

import de.csdev.ebus.command.datatypes.EBusAbstractType;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.command.datatypes.ext.EBusTypeDate;
import de.csdev.ebus.command.datatypes.ext.EBusTypeTime;
import de.csdev.ebus.utils.EBusDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusTypeDateTime
extends EBusAbstractType<EBusDateTime> {
    private static final Logger logger = LoggerFactory.getLogger(EBusTypeDateTime.class);
    public static String TYPE_DATETIME = "datetime";
    private static String[] supportedTypes = new String[]{TYPE_DATETIME};
    public static String TIME_FIRST = "timeFirst";
    public static String VARIANT_DATE = "variantDate";
    public static String VARIANT_TIME = "variantTime";
    private boolean timeFirst = true;
    private String variantDate = EBusTypeDate.DEFAULT;
    private String variantTime = EBusTypeTime.DEFAULT;

    @Override
    protected byte[] applyByteOrder(byte[] data) {
        if (this.reverseByteOrder) {
            logger.warn("Parameter 'reverseByteOrder' not supported for EBusTypeDateTime yet!");
        }
        return ArrayUtils.clone((byte[])data);
    }

    @Override
    public EBusDateTime decodeInt(byte @Nullable [] data) throws EBusTypeException {
        IEBusType<Object> dateType = this.getDateType();
        IEBusType<Object> timeType = this.getTimeType();
        byte[] timeData = null;
        byte[] dateData = null;
        boolean anyDate = false;
        boolean anyTime = false;
        if (this.timeFirst) {
            timeData = Arrays.copyOf(data, timeType.getTypeLength());
            dateData = Arrays.copyOfRange(data, timeData.length, timeData.length + dateType.getTypeLength());
        } else {
            dateData = Arrays.copyOf(data, dateType.getTypeLength());
            timeData = Arrays.copyOfRange(data, dateData.length, dateData.length + timeType.getTypeLength());
        }
        EBusDateTime time = (EBusDateTime)timeType.decode(timeData);
        EBusDateTime date = (EBusDateTime)dateType.decode(dateData);
        if (time == null) {
            logger.trace("The decoded time part of datetime is null!");
        }
        if (date == null) {
            logger.trace("The decoded date part of datetime is null!");
        }
        Calendar calendar = null;
        if (date == null) {
            anyDate = true;
            calendar = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        } else {
            calendar = date.getCalendar();
        }
        if (time == null) {
            anyTime = true;
        } else {
            calendar.set(11, time.getCalendar().get(11));
            calendar.set(12, time.getCalendar().get(12));
            calendar.set(13, time.getCalendar().get(13));
        }
        return new EBusDateTime(calendar, anyDate, anyTime);
    }

    @Override
    public byte[] encodeInt(@Nullable Object data) throws EBusTypeException {
        IEBusType<Object> dateType = this.getDateType();
        IEBusType<Object> timeType = this.getTimeType();
        Calendar calendar = null;
        byte[] result = new byte[this.getTypeLength()];
        if (data instanceof EBusDateTime) {
            calendar = ((EBusDateTime)data).getCalendar();
        } else if (data instanceof Calendar) {
            calendar = (Calendar)data;
        }
        if (calendar == null) {
            return this.applyByteOrder(this.getReplaceValue());
        }
        byte[] timeData = timeType.encode(calendar);
        byte[] dateData = dateType.encode(calendar);
        if (this.timeFirst) {
            System.arraycopy(timeData, 0, result, 0, timeData.length);
            System.arraycopy(dateData, 0, result, timeData.length, dateData.length);
        } else {
            System.arraycopy(dateData, 0, result, 0, dateData.length);
            System.arraycopy(timeData, 0, result, dateData.length, timeData.length);
        }
        return result;
    }

    private IEBusType<Object> getDateType() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("variant", this.variantDate);
        return this.types.getType(EBusTypeDate.TYPE_DATE, properties);
    }

    @Override
    public String[] getSupportedTypes() {
        return supportedTypes;
    }

    private IEBusType<Object> getTimeType() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("variant", this.variantTime);
        return this.types.getType(EBusTypeTime.TYPE_TIME, properties);
    }

    @Override
    public int getTypeLength() {
        IEBusType<Object> dateType = this.getDateType();
        IEBusType<Object> timeType = this.getTimeType();
        return dateType.getTypeLength() + timeType.getTypeLength();
    }

    public String toString() {
        return "EBusTypeDateTime [timeFirst=" + this.timeFirst + ", " + (this.variantDate != null ? "variantDate=" + this.variantDate + ", " : "") + (this.variantTime != null ? "variantTime=" + this.variantTime : "") + "]";
    }
}

