/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.command;

import de.csdev.ebus.command.EBusCommandException;
import de.csdev.ebus.command.EBusCommandValue;
import de.csdev.ebus.command.IEBusCommand;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.IEBusNestedValue;
import de.csdev.ebus.command.IEBusValue;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.command.datatypes.IEBusComplexType;
import de.csdev.ebus.command.datatypes.IEBusType;
import de.csdev.ebus.command.datatypes.ext.EBusTypeBytes;
import de.csdev.ebus.core.EBusConsts;
import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.core.EBusReceiveStateMachine;
import de.csdev.ebus.utils.EBusUtils;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusCommandUtils {
    private static final Logger logger = LoggerFactory.getLogger(EBusCommandUtils.class);

    private EBusCommandUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static @NonNull String getFullId(@NonNull IEBusCommandMethod commandMethod) {
        Objects.requireNonNull(commandMethod);
        return EBusCommandUtils.getFullId(commandMethod.getParent()) + ":" + (Object)((Object)commandMethod.getMethod());
    }

    public static @NonNull String getFullId(@NonNull IEBusCommand command) {
        Objects.requireNonNull(command);
        return command.getParentCollection().getId() + "." + command.getId();
    }

    public static byte @NonNull [] prepareSendTelegram(byte @NonNull [] data) throws EBusDataException {
        EBusReceiveStateMachine machine = new EBusReceiveStateMachine();
        machine.updateBytes(data);
        if (machine.getState() == EBusReceiveStateMachine.State.CRC1) {
            return data;
        }
        if (machine.getState() == EBusReceiveStateMachine.State.DATA1 && machine.getRemainDataLength() == 0) {
            byte[] dataExt = new byte[data.length + 1];
            System.arraycopy(data, 0, dataExt, 0, data.length);
            dataExt[dataExt.length - 1] = machine.getCurrentCrc();
            return dataExt;
        }
        throw new EBusDataException("Invalid telegram!");
    }

    public static byte @NonNull [] checkRawTelegram(byte @NonNull [] data) throws EBusDataException {
        EBusReceiveStateMachine machine = new EBusReceiveStateMachine();
        machine.updateBytes(data);
        return machine.getTelegramData();
    }

    public static byte unescapeSymbol(byte reversedByte) {
        if (reversedByte == 0) {
            return -87;
        }
        return reversedByte == 1 ? (byte)-86 : (byte)reversedByte;
    }

    public static byte @NonNull [] escapeSymbol(byte b) {
        if (b == -87) {
            return EBusConsts.ESCAPE_REPLACEMENT;
        }
        if (b == -86) {
            return EBusConsts.SYN_REPLACEMENT;
        }
        return new byte[]{b};
    }

    public static @NonNull ByteBuffer buildCompleteTelegram(byte source, byte target, byte[] command, byte[] masterData, byte[] slaveData) {
        boolean isMastereMaster = EBusUtils.isMasterAddress(target);
        boolean isBroadcast = target == -2;
        boolean isMasterSlave = !isMastereMaster && !isBroadcast;
        ByteBuffer buf = ByteBuffer.allocate(50);
        buf.put(EBusCommandUtils.buildPartMasterTelegram(source, target, command, masterData));
        if (isMasterSlave && slaveData != null) {
            ByteBuffer slaveTelegramPart = EBusCommandUtils.buildPartSlave(slaveData);
            buf.put(slaveTelegramPart);
            buf.put((byte)0);
            buf.put((byte)-86);
        }
        if (isMastereMaster) {
            buf.put((byte)0);
            buf.put((byte)-86);
        }
        if (isBroadcast) {
            buf.put((byte)-86);
        }
        buf.limit(buf.position());
        buf.position(0);
        return buf;
    }

    public static @NonNull ByteBuffer buildPartMasterTelegram(byte source, byte target, byte[] command, byte[] masterData) {
        ByteBuffer buf = ByteBuffer.allocate(50);
        buf.put(source);
        buf.put(target);
        buf.put(command);
        buf.put((byte)masterData.length);
        for (byte b : masterData) {
            buf.put(EBusCommandUtils.escapeSymbol(b));
        }
        byte crc8 = EBusUtils.crc8(buf.array(), buf.position());
        buf.put(EBusCommandUtils.escapeSymbol(crc8));
        buf.limit(buf.position());
        buf.position(0);
        return buf;
    }

    public static @NonNull ByteBuffer buildPartSlave(byte @NonNull [] slaveData) {
        Objects.requireNonNull(slaveData, "slaveData");
        ByteBuffer buf = ByteBuffer.allocate(50);
        buf.put((byte)0);
        if (slaveData.length > 0) {
            buf.put((byte)slaveData.length);
            for (byte b : slaveData) {
                buf.put(EBusCommandUtils.escapeSymbol(b));
            }
            byte crc8 = EBusUtils.crc8(buf.array(), buf.position());
            buf.put(EBusCommandUtils.escapeSymbol(crc8));
        } else {
            buf.put((byte)0);
        }
        buf.limit(buf.position());
        buf.position(0);
        return buf;
    }

    public static @NonNull ByteBuffer composeMasterData(@NonNull IEBusCommandMethod commandMethod, @Nullable Map<String, Object> values) throws EBusTypeException {
        Objects.requireNonNull(commandMethod);
        ByteBuffer buf = ByteBuffer.allocate(50);
        HashMap<Integer, IEBusComplexType> complexTypes = new HashMap<Integer, IEBusComplexType>();
        List<@NonNull IEBusValue> masterTypes = commandMethod.getMasterTypes();
        if (masterTypes != null) {
            for (IEBusValue entry : masterTypes) {
                IEBusType<?> type = entry.getType();
                byte[] b = null;
                if (entry instanceof IEBusNestedValue) {
                    IEBusNestedValue nestedValue = (IEBusNestedValue)((Object)entry);
                    List<@NonNull IEBusValue> list = nestedValue.getChildren();
                    int n = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        Boolean object;
                        IEBusValue childValue = list.get(i);
                        if (values == null || !values.containsKey(childValue.getName()) || !(object = (Boolean)values.get(childValue.getName())).booleanValue()) continue;
                        n |= 1 << i;
                    }
                    b = new byte[]{(byte)n};
                } else if (values != null && values.containsKey(entry.getName())) {
                    b = type.encode(values.get(entry.getName()));
                } else if (type instanceof IEBusComplexType) {
                    complexTypes.put(buf.position(), (IEBusComplexType)((Object)type));
                    b = new byte[entry.getType().getTypeLength()];
                } else {
                    b = type.encode(entry.getDefaultValue());
                }
                if (b == null) {
                    throw new EBusTypeException("Encoded value is null! " + type.toString());
                }
                buf.put(b);
            }
        }
        if (!complexTypes.isEmpty()) {
            int orgPos = buf.position();
            buf.limit(buf.position());
            for (Map.Entry entry : complexTypes.entrySet()) {
                buf.position((Integer)entry.getKey());
                buf.put(((IEBusComplexType)entry.getValue()).encodeComplex(buf));
            }
            buf.position(orgPos);
        }
        buf.limit(buf.position());
        buf.position(0);
        return buf;
    }

    public static @NonNull ByteBuffer buildMasterTelegram(@NonNull IEBusCommandMethod commandMethod, @Nullable Byte source, @Nullable Byte target, @Nullable Map<String, Object> values) throws EBusTypeException, EBusCommandException {
        return EBusCommandUtils.buildMasterTelegram(commandMethod, source, target, values, false);
    }

    public static @NonNull ByteBuffer buildMasterTelegram(@NonNull IEBusCommandMethod commandMethod, @Nullable Byte source, @Nullable Byte target, @Nullable Map<String, Object> values, boolean skipAddressChecks) throws EBusTypeException, EBusCommandException {
        Objects.requireNonNull(commandMethod, "commandMethod");
        if (source == null && commandMethod.getSourceAddress() != null) {
            source = commandMethod.getSourceAddress();
        }
        if (target == null && commandMethod.getDestinationAddress() != null) {
            target = commandMethod.getDestinationAddress();
        }
        if (source == null) {
            throw new IllegalArgumentException("Parameter source is null!");
        }
        if (target == null) {
            throw new IllegalArgumentException("Parameter target is null!");
        }
        Byte targetChecked = target;
        if (!skipAddressChecks) {
            if (commandMethod.getType().equals((Object)IEBusCommandMethod.Type.BROADCAST)) {
                if (target != -2) {
                    targetChecked = -2;
                    if (logger.isWarnEnabled()) {
                        logger.warn("Replace target address {} with valid broadcast address 0xFE !", (Object)EBusUtils.toHexDumpString(target));
                    }
                }
            } else if (commandMethod.getType().equals((Object)IEBusCommandMethod.Type.MASTER_MASTER)) {
                if (!EBusUtils.isMasterAddress(target)) {
                    targetChecked = EBusUtils.getMasterAddress(target);
                    if (targetChecked == null) {
                        throw new IllegalArgumentException(String.format("Cannot replace the slave address 0x%s with a master address because it is a slave address without a master address.", EBusUtils.toHexDumpString(target)));
                    }
                    if (logger.isWarnEnabled()) {
                        logger.warn("Replace slave target address {} with valid master address {}!", (Object)EBusUtils.toHexDumpString(target), (Object)EBusUtils.toHexDumpString(targetChecked));
                    }
                }
            } else if (commandMethod.getType().equals((Object)IEBusCommandMethod.Type.MASTER_SLAVE) && EBusUtils.isMasterAddress(target)) {
                targetChecked = EBusUtils.getSlaveAddress(target);
                if (logger.isWarnEnabled()) {
                    logger.warn("Replace master target address {} with valid slave address {}!", (Object)EBusUtils.toHexDumpString(target), (Object)EBusUtils.toHexDumpString(targetChecked));
                }
            }
        }
        if (targetChecked == null) {
            throw new EBusCommandException("Unable to calculate the correct trarget address!");
        }
        byte[] data = EBusUtils.toByteArray(EBusCommandUtils.composeMasterData(commandMethod, values));
        return EBusCommandUtils.buildPartMasterTelegram(source, targetChecked, commandMethod.getCommand(), data);
    }

    private static @Nullable Object applyNumberOperations(@Nullable Object decode, @Nullable IEBusValue ev) {
        if (ev instanceof EBusCommandValue) {
            EBusCommandValue nev = (EBusCommandValue)ev;
            if (decode instanceof BigDecimal) {
                BigDecimal multiply = (BigDecimal)decode;
                if (nev.getFactor() != null) {
                    multiply = multiply.multiply(nev.getFactor());
                    decode = multiply;
                }
                if (nev.getMin() != null && multiply.compareTo(nev.getMin()) < 0) {
                    logger.debug("Value {} with {} is smaller then allowed {}", new Object[]{ev.getName(), multiply, nev.getMax()});
                    decode = null;
                }
                if (nev.getMax() != null && multiply.compareTo(nev.getMax()) > 0) {
                    logger.debug("Value {} with {} is larger then allowed {}", new Object[]{ev.getName(), multiply, nev.getMax()});
                    decode = null;
                }
            }
        }
        return decode;
    }

    private static int decodeValueList(@Nullable List<@NonNull IEBusValue> values, byte @NonNull [] data, @NonNull HashMap<String, Object> result, int pos) throws EBusTypeException {
        if (values != null) {
            for (IEBusValue ev : values) {
                IEBusNestedValue evc;
                byte[] src = null;
                Object decode = null;
                if (ev.getType() instanceof IEBusComplexType) {
                    decode = ((IEBusComplexType)((Object)ev.getType())).decodeComplex(data, pos);
                } else {
                    src = new byte[ev.getType().getTypeLength()];
                    System.arraycopy(data, pos - 1, src, 0, src.length);
                    decode = ev.getType().decode(src);
                }
                if (ev instanceof IEBusNestedValue && src != null && (evc = (IEBusNestedValue)((Object)ev)).hasChildren()) {
                    for (IEBusValue child : evc.getChildren()) {
                        Object decode2 = child.getType().decode(src);
                        if (!StringUtils.isNotEmpty((String)child.getName())) continue;
                        decode2 = EBusCommandUtils.applyNumberOperations(decode2, ev);
                        result.put(child.getName(), decode2);
                    }
                }
                if (StringUtils.isNotEmpty((String)ev.getName())) {
                    decode = EBusCommandUtils.applyNumberOperations(decode, ev);
                    result.put(ev.getName(), decode);
                }
                pos += ev.getType().getTypeLength();
            }
        }
        return pos;
    }

    public static @NonNull Map<String, Object> decodeTelegram(@NonNull IEBusCommandMethod commandChannel, byte @NonNull [] data) throws EBusTypeException {
        Objects.requireNonNull(commandChannel, "commandChannel");
        Objects.requireNonNull(data, "data");
        HashMap<String, Object> result = new HashMap<String, Object>();
        int pos = 6;
        pos = EBusCommandUtils.decodeValueList(commandChannel.getMasterTypes(), data, result, pos);
        EBusCommandUtils.decodeValueList(commandChannel.getSlaveTypes(), data, result, pos += 3);
        return result;
    }

    public static @NonNull ByteBuffer getMasterTelegramMask(@NonNull IEBusCommandMethod commandChannel) {
        Objects.requireNonNull(commandChannel, "Parameter command is null!");
        ByteBuffer buf = ByteBuffer.allocate(50);
        buf.put(commandChannel.getSourceAddress() == null ? (byte)0 : -1);
        buf.put(commandChannel.getDestinationAddress() == null ? (byte)0 : -1);
        buf.put(new byte[]{-1, -1});
        buf.put((byte)-1);
        List<@NonNull IEBusValue> masterTypes = commandChannel.getMasterTypes();
        if (masterTypes != null) {
            for (IEBusValue entry : masterTypes) {
                int i;
                IEBusType<?> type = entry.getType();
                if (entry.getName() == null && type instanceof EBusTypeBytes && entry.getDefaultValue() != null) {
                    for (i = 0; i < type.getTypeLength(); ++i) {
                        buf.put((byte)-1);
                    }
                    continue;
                }
                for (i = 0; i < type.getTypeLength(); ++i) {
                    buf.put((byte)0);
                }
            }
        }
        buf.put((byte)0);
        buf.limit(buf.position());
        buf.position(0);
        return buf;
    }

    public static int getSlaveDataLength(@NonNull IEBusCommandMethod command) {
        Objects.requireNonNull(command, "Parameter command is null!");
        if (command.getType() == IEBusCommandMethod.Type.MASTER_SLAVE) {
            int len = 0;
            List<@NonNull IEBusValue> slaveTypes = command.getSlaveTypes();
            if (slaveTypes != null) {
                for (IEBusValue value : slaveTypes) {
                    if (value.getType() == null) continue;
                    len += value.getType().getTypeLength();
                }
            }
            return len;
        }
        return -1;
    }
}

