/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.utils;

import de.csdev.ebus.core.EBusWorkerThreadFactory;
import de.csdev.ebus.utils.CommonsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Emulator {
    private final Logger logger = LoggerFactory.getLogger(Emulator.class);
    private PipedInputStream in;
    private PipedOutputStream out;
    private ExecutorService pipeThreadExecutor;
    private ScheduledExecutorService playThreadExecutor;
    private Future<?> autoSyncFuture = null;
    private int factor = 10;

    private void stopAutoSync() {
        if (this.autoSyncFuture != null) {
            this.autoSyncFuture.cancel(true);
            this.autoSyncFuture = null;
        }
    }

    private void startAutoSync() {
        long v = 40L * (long)this.factor;
        this.autoSyncFuture = this.playThreadExecutor.schedule(() -> this.write((byte)-86), v, TimeUnit.MILLISECONDS);
    }

    public Emulator() {
        this(1, true);
    }

    public Emulator(int factor, boolean autoSync) {
        this.factor = factor;
        this.pipeThreadExecutor = Executors.newSingleThreadExecutor(new EBusWorkerThreadFactory("ebus-emu-pipe", false));
        this.playThreadExecutor = Executors.newScheduledThreadPool(1, new EBusWorkerThreadFactory("ebus-emu-play", false));
        if (autoSync) {
            this.startAutoSync();
        }
        try {
            this.in = new PipedInputStream();
            this.out = new PipedOutputStream(this.in);
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void write(byte b) {
        this.pipeThreadExecutor.submit(() -> {
            try {
                PipedOutputStream pipedOutputStream = this.out;
                synchronized (pipedOutputStream) {
                    this.stopAutoSync();
                    this.out.write(b);
                    this.out.flush();
                    try {
                        this.out.wait(4 * this.factor);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    this.startAutoSync();
                }
            }
            catch (IOException e2) {
                this.logger.trace("error!", (Throwable)e2);
            }
        });
    }

    public void write(byte[] byteArray) {
        this.pipeThreadExecutor.submit(() -> {
            for (byte b : byteArray) {
                this.write(b);
            }
        });
    }

    public void close() {
        if (this.autoSyncFuture != null) {
            this.autoSyncFuture.cancel(false);
        }
        this.playThreadExecutor.shutdownNow();
        this.pipeThreadExecutor.shutdownNow();
        try {
            this.playThreadExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.trace("error!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            this.pipeThreadExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.trace("error!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        CommonsUtils.closeQuietly(this.in);
        CommonsUtils.closeQuietly(this.out);
    }
}

