/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.utils;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusUtils {
    protected static final byte[] CRC_TAB_8_VALUE = new byte[]{0, -101, -83, 54, -63, 90, 108, -9, 25, -126, -76, 47, -40, 67, 117, -18, 50, -87, -97, 4, -13, 104, 94, -59, 43, -80, -122, 29, -22, 113, 71, -36, 100, -1, -55, 82, -91, 62, 8, -109, 125, -26, -48, 75, -68, 39, 17, -118, 86, -51, -5, 96, -105, 12, 58, -95, 79, -44, -30, 121, -114, 21, 35, -72, -56, 83, 101, -2, 9, -110, -92, 63, -47, 74, 124, -25, 16, -117, -67, 38, -6, 97, 87, -52, 59, -96, -106, 13, -29, 120, 78, -43, 34, -71, -113, 20, -84, 55, 1, -102, 109, -10, -64, 91, -75, 46, 24, -125, 116, -17, -39, 66, -98, 5, 51, -88, 95, -60, -14, 105, -121, 28, 42, -79, 70, -35, -21, 112, 11, -112, -90, 61, -54, 81, 103, -4, 18, -119, -65, 36, -45, 72, 126, -27, 57, -94, -108, 15, -8, 99, 85, -50, 32, -69, -115, 22, -31, 122, 76, -41, 111, -12, -62, 89, -82, 53, 3, -104, 118, -19, -37, 64, -73, 44, 26, -127, 93, -58, -16, 107, -100, 7, 49, -86, 68, -33, -23, 114, -123, 30, 40, -77, -61, 88, 110, -11, 2, -103, -81, 52, -38, 65, 119, -20, 27, -128, -74, 45, -15, 106, 92, -57, 48, -85, -99, 6, -24, 115, 69, -34, 41, -78, -124, 31, -89, 60, 10, -111, 102, -3, -53, 80, -66, 37, 19, -120, 127, -28, -46, 73, -107, 14, 56, -93, 84, -49, -7, 98, -116, 23, 33, -70, 77, -42, -32, 123};

    private EBusUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static byte @Nullable [] leftPadByteArray(byte @Nullable [] source, int size) {
        byte[] bs = new byte[size];
        if (source == null || size < source.length) {
            return null;
        }
        int startPos = size - source.length;
        System.arraycopy(source, 0, bs, startPos, source.length);
        return bs;
    }

    public static byte crc8(byte data, byte crcInit, byte poly) {
        byte d = data;
        byte crc = crcInit;
        for (int i = 0; i < 8; ++i) {
            byte polynom = (EBusUtils.uint(crc) & 0x80) != 0 ? poly : (byte)0;
            crc = (byte)((EBusUtils.uint(crc) & 0xFFFFFF7F) << 1);
            if ((EBusUtils.uint(d) & 0x80) != 0) {
                crc = (byte)(EBusUtils.uint(crc) | 1);
            }
            crc = (byte)(EBusUtils.uint(crc) ^ EBusUtils.uint(polynom));
            d = (byte)(EBusUtils.uint(d) << 1);
        }
        return crc;
    }

    public static byte crc8(byte @Nullable [] data, int len) {
        byte ucCrc = 0;
        if (data == null) {
            return ucCrc;
        }
        for (int i = 0; i < len; ++i) {
            byte b = data[i];
            ucCrc = EBusUtils.crc8_tab(b, ucCrc);
        }
        return ucCrc;
    }

    public static byte crc8_tab(byte data, byte crcInit) {
        short ci = (short)(crcInit & 0xFF);
        return (byte)(CRC_TAB_8_VALUE[ci] ^ data & 0xFF);
    }

    public static @Nullable Byte getMasterAddress(byte slaveAddress) {
        byte masterAddress;
        if (slaveAddress == -87 || slaveAddress == -86) {
            return null;
        }
        if (!EBusUtils.isMasterAddress(slaveAddress) && EBusUtils.isMasterAddress(masterAddress = (byte)(slaveAddress == 4 ? -1 : slaveAddress - 5))) {
            return masterAddress;
        }
        return null;
    }

    public static @Nullable Byte getSlaveAddress(byte masterAddress) {
        if (EBusUtils.isMasterAddress(masterAddress)) {
            return (byte)(masterAddress == -1 ? 4 : masterAddress + 5);
        }
        return null;
    }

    public static boolean isMasterAddress(byte address) {
        if (!EBusUtils.isValidAddress(address)) {
            return false;
        }
        byte addr = (byte)((byte)(address >>> 4) & 0xF);
        byte prio = (byte)(address & 0xF);
        if (EBusUtils.isValidAddress(address)) {
            boolean addrB = addr == 0 || addr == 1 || addr == 3 || addr == 7 || addr == 15;
            boolean prioB = prio == 0 || prio == 1 || prio == 3 || prio == 7 || prio == 15;
            return addrB && prioB;
        }
        return false;
    }

    public static boolean isSlaveAddress(byte address) {
        return EBusUtils.isValidAddress(address) && !EBusUtils.isMasterAddress(address);
    }

    public static boolean isValidAddress(byte address) {
        return address != -2 && address != -86 && address != -87;
    }

    public static @Nullable Byte toByte(@Nullable String hexDumpString) {
        if (StringUtils.isEmpty((CharSequence)hexDumpString)) {
            return null;
        }
        return EBusUtils.toByteArray(hexDumpString)[0];
    }

    public static byte[] toByteArray(@Nullable ByteBuffer buffer) {
        if (buffer == null) {
            return new byte[0];
        }
        int size = 0;
        size = buffer.position() == 0 ? buffer.limit() : buffer.position();
        byte[] data = new byte[size];
        ByteBuffer duplicate = buffer.duplicate();
        duplicate.clear();
        duplicate.get(data);
        return data;
    }

    public static byte[] toByteArray(@Nullable String hexDumpString) throws NumberFormatException {
        if (hexDumpString == null || StringUtils.isEmpty((CharSequence)hexDumpString)) {
            return new byte[0];
        }
        String[] elements = hexDumpString.split(" ");
        byte[] result = new byte[elements.length];
        int pos = 0;
        for (String val : elements) {
            result[pos++] = Integer.valueOf(val, 16).byteValue();
        }
        return result;
    }

    public static byte[] toByteArray2(@Nullable String hexDumpString) throws NumberFormatException {
        String h = hexDumpString;
        if (h == null || StringUtils.isEmpty((CharSequence)h)) {
            return new byte[0];
        }
        if (h.length() % 2 != 0) {
            h = "0" + h;
        }
        byte[] result = new byte[h.length() / 2];
        int pos = 0;
        for (int i = 0; i < h.length(); i += 2) {
            String val = h.substring(i, i + 2);
            result[pos++] = Integer.valueOf(val, 16).byteValue();
        }
        return result;
    }

    public static String mergeHexDumpStrings(String ... args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String string : args) {
            if (string == null || !StringUtils.isNotEmpty((CharSequence)string)) continue;
            sb.append(string.length() % 2 == 0 ? string : "0" + string);
        }
        sb = EBusUtils.toHexDumpString(EBusUtils.toByteArray2(sb.toString()));
        return Objects.requireNonNull(sb.toString());
    }

    public static String toHexDumpString(@Nullable Byte data) {
        if (data == null) {
            return "";
        }
        String format = String.format("%02X", 0xFF & data);
        return Objects.requireNonNull(format);
    }

    public static StringBuilder toHexDumpString(byte @Nullable [] data) {
        StringBuilder sb = new StringBuilder();
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                byte c = data[i];
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(EBusUtils.toHexDumpString(c));
            }
        }
        return sb;
    }

    public static StringBuilder toHexDumpString(@Nullable ByteBuffer data) {
        StringBuilder sb = new StringBuilder();
        if (data == null) {
            return sb;
        }
        int size = 0;
        size = data.position() == 0 ? data.limit() : data.position();
        for (int i = 0; i < size; ++i) {
            byte c = data.get(i);
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(EBusUtils.toHexDumpString(c));
        }
        return sb;
    }

    public static String toPrintHexDumpString(@Nullable Byte data) {
        if (data != null) {
            return "0x" + String.format("%02X", 0xFF & data);
        }
        return "";
    }

    public static int uint(byte v) {
        return v & 0xFF;
    }
}

