/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.utils;

import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.service.parser.IEBusParserListener;
import de.csdev.ebus.utils.EBusUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EBusTelegramWriter
implements IEBusParserListener {
    @NonNullByDefault(value={})
    private final Logger logger = LoggerFactory.getLogger(EBusTelegramWriter.class);
    private @Nullable BufferedWriter writerResolved;
    private @Nullable BufferedWriter writerUnresolved;
    private File loggingDirectory;

    public EBusTelegramWriter(File loggingDirectory) {
        this.loggingDirectory = loggingDirectory;
    }

    @Override
    public void onTelegramResolved(IEBusCommandMethod commandChannel, Map<String, @Nullable Object> result, byte[] receivedData, @Nullable Integer sendQueueId) {
        try {
            if (this.writerResolved == null) {
                this.writerResolved = this.open("ebus-resolved.csv");
            }
            String comment = String.format("%s > %s.%s", new Object[]{commandChannel.getMethod(), commandChannel.getParent().getParentCollection().getId(), commandChannel.getParent().getId()});
            this.write(this.writerResolved, receivedData, comment);
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    @Override
    public void onTelegramResolveFailed(@Nullable IEBusCommandMethod commandChannel, byte @Nullable [] receivedData, @Nullable Integer sendQueueId, @Nullable String exceptionMessage) {
        try {
            if (this.writerUnresolved == null) {
                this.writerUnresolved = this.open("ebus-unresolved.csv");
            }
            if (receivedData != null) {
                this.write(this.writerUnresolved, receivedData, "");
            }
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    private BufferedWriter open(String filename) throws IOException {
        File file = new File(this.loggingDirectory, filename);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        if (!file.exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Create new file {}", (Object)filename);
            }
            if (!file.createNewFile()) {
                throw new IOException("Unable to create file!");
            }
        }
        writer.write("Date/Time;");
        writer.write("SRC;");
        writer.write("DST;");
        writer.write("CMD;");
        writer.write("REMAIN_DATA;");
        writer.newLine();
        writer.flush();
        return writer;
    }

    public void close() {
        try {
            BufferedWriter w = this.writerResolved;
            if (w != null) {
                ((Writer)w).flush();
                ((Writer)w).close();
                this.writerResolved = null;
            }
            if ((w = this.writerUnresolved) != null) {
                ((Writer)w).flush();
                ((Writer)w).close();
                this.writerUnresolved = null;
            }
        }
        catch (IOException e) {
            this.logger.error("error!", (Throwable)e);
        }
    }

    private void write(@Nullable BufferedWriter writer, byte[] receivedData, @Nullable String comment) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(date));
        sb.append(";");
        sb.append('\"' + EBusUtils.toHexDumpString(receivedData[0]) + '\"');
        sb.append(";");
        sb.append('\"' + EBusUtils.toHexDumpString(receivedData[1]) + '\"');
        sb.append(";");
        byte[] command = Arrays.copyOfRange(receivedData, 2, 4);
        sb.append('\"' + EBusUtils.toHexDumpString(command).toString() + '\"');
        sb.append(";");
        byte[] rest = Arrays.copyOfRange(receivedData, 4, receivedData.length);
        sb.append('\"' + EBusUtils.toHexDumpString(rest).toString() + '\"');
        sb.append(";");
        sb.append(comment == null ? "" : comment);
        sb.append("\n");
        if (writer != null) {
            writer.append(sb).flush();
        }
    }
}

