/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusDateTime {
    private Calendar calendar;
    private boolean anyDate = false;
    private boolean anyTime = false;

    public EBusDateTime(Calendar calendar, boolean anyDate, boolean anyTime) {
        this.calendar = calendar;
        this.anyDate = anyDate;
        this.anyTime = anyTime;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public boolean isAnyDate() {
        return this.anyDate;
    }

    public boolean isAnyTime() {
        return this.anyTime;
    }

    public String toString() {
        SimpleDateFormat format = null;
        if (this.calendar == null) {
            return "<null>";
        }
        if (this.anyDate && this.anyTime) {
            return "<any>";
        }
        format = this.anyDate ? new SimpleDateFormat("HH:mm:ss") : (this.anyTime ? new SimpleDateFormat("dd.MM.yyyy") : new SimpleDateFormat("dd.MM.yyyy HH:mm:ss"));
        return format.format(this.calendar.getTime());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anyDate ? 1231 : 1237);
        result = 31 * result + (this.anyTime ? 1231 : 1237);
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EBusDateTime other = (EBusDateTime)obj;
        if (this.anyDate != other.anyDate) {
            return false;
        }
        if (this.anyTime != other.anyTime) {
            return false;
        }
        return !(this.calendar == null ? other.calendar != null : !this.calendar.equals(other.calendar));
    }
}

