/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.service.parser;

import de.csdev.ebus.command.EBusCommandRegistry;
import de.csdev.ebus.command.EBusCommandUtils;
import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.command.datatypes.EBusTypeException;
import de.csdev.ebus.core.EBusConnectorEventListener;
import de.csdev.ebus.service.parser.IEBusParserListener;
import de.csdev.ebus.utils.EBusUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusParserService
extends EBusConnectorEventListener {
    private static final Logger logger = LoggerFactory.getLogger(EBusParserService.class);
    private final @NonNull List<IEBusParserListener> listeners = new CopyOnWriteArrayList<IEBusParserListener>();
    private @NonNull EBusCommandRegistry commandRegistry;

    public EBusParserService(@NonNull EBusCommandRegistry configurationProvider) {
        Objects.requireNonNull(configurationProvider);
        this.commandRegistry = configurationProvider;
    }

    public void dispose() {
        this.listeners.clear();
    }

    public void addEBusParserListener(@NonNull IEBusParserListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public boolean removeEBusParserListener(@NonNull IEBusParserListener listener) {
        Objects.requireNonNull(listener);
        return this.listeners.remove(listener);
    }

    @Override
    public void onTelegramReceived(byte @NonNull [] receivedData, @Nullable Integer sendQueueId) {
        List<IEBusCommandMethod> commandChannelList = this.commandRegistry.find(receivedData);
        if (commandChannelList.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("No command method matches the telegram {} ...", (Object)EBusUtils.toHexDumpString(receivedData));
            }
            this.fireOnTelegramFailed(null, receivedData, sendQueueId, "No command method matches the telegram!");
            return;
        }
        if (!commandChannelList.isEmpty()) {
            for (IEBusCommandMethod commandChannel : commandChannelList) {
                try {
                    if (commandChannel == null) continue;
                    Map<String, Object> map = EBusCommandUtils.decodeTelegram(commandChannel, receivedData);
                    this.fireOnTelegramResolved(commandChannel, map, receivedData, sendQueueId);
                }
                catch (EBusTypeException e) {
                    this.fireOnTelegramFailed(commandChannel, receivedData, sendQueueId, e.getMessage());
                    logger.error("Parsing error details >> Data: {} - {} {}", new Object[]{EBusUtils.toHexDumpString(receivedData), commandChannel.getParent(), commandChannel.getType()});
                    logger.error("error!", (Throwable)e);
                }
            }
        }
    }

    private void fireOnTelegramResolved(@NonNull IEBusCommandMethod commandChannel, @NonNull Map<@NonNull String, @Nullable Object> result, byte @NonNull [] receivedData, @Nullable Integer sendQueueId) {
        for (IEBusParserListener listener : this.listeners) {
            try {
                listener.onTelegramResolved(commandChannel, result, receivedData, sendQueueId);
            }
            catch (Exception e) {
                logger.error("Error while firing onTelegramResolved events!", (Throwable)e);
            }
        }
    }

    private void fireOnTelegramFailed(@Nullable IEBusCommandMethod commandChannel, byte @NonNull [] receivedData, @Nullable Integer sendQueueId, @NonNull String exceptionMessage) {
        for (IEBusParserListener listener : this.listeners) {
            try {
                listener.onTelegramResolveFailed(commandChannel, receivedData, sendQueueId, exceptionMessage);
            }
            catch (Exception e) {
                logger.error("Error while firing onTelegramResolved events!", (Throwable)e);
            }
        }
    }
}

