/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.service.metrics;

import de.csdev.ebus.command.IEBusCommandMethod;
import de.csdev.ebus.core.EBusConnectorEventListener;
import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.service.parser.IEBusParserListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class EBusMetricsService
extends EBusConnectorEventListener
implements IEBusParserListener {
    private static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    private BigDecimal resolved = BigDecimal.valueOf(0L);
    private BigDecimal unresolved = BigDecimal.valueOf(0L);
    private BigDecimal received = BigDecimal.valueOf(0L);
    private BigDecimal failed = BigDecimal.valueOf(0L);
    private BigDecimal connectionFailed = BigDecimal.valueOf(0L);
    private BigDecimal receivedAmount = BigDecimal.valueOf(0L);
    private Map<EBusDataException.EBusError, @Nullable BigDecimal> failedMap = new EnumMap<EBusDataException.EBusError, BigDecimal>(EBusDataException.EBusError.class);

    public void clear() {
        this.resolved = BigDecimal.valueOf(0L);
        this.unresolved = BigDecimal.valueOf(0L);
        this.received = BigDecimal.valueOf(0L);
        this.failed = BigDecimal.valueOf(0L);
        this.connectionFailed = BigDecimal.valueOf(0L);
        this.receivedAmount = BigDecimal.valueOf(0L);
        this.failedMap.clear();
    }

    @Override
    public void onTelegramResolved(IEBusCommandMethod commandChannel, Map<String, @Nullable Object> result, byte @NonNull [] receivedData, @Nullable Integer sendQueueId) {
        this.resolved = this.resolved.add(BigDecimal.ONE);
    }

    @Override
    public void onTelegramResolveFailed(@Nullable IEBusCommandMethod commandChannel, byte @Nullable [] receivedData, @Nullable Integer sendQueueId, @Nullable String exceptionMessage) {
        this.unresolved = this.unresolved.add(BigDecimal.ONE);
    }

    @Override
    public void onTelegramReceived(byte[] receivedData, @Nullable Integer sendQueueId) {
        this.received = this.received.add(BigDecimal.ONE);
        this.receivedAmount = this.receivedAmount.add(BigDecimal.valueOf(receivedData.length));
    }

    @Override
    public void onTelegramException(EBusDataException exception, @Nullable Integer sendQueueId) {
        EBusDataException.EBusError errorCode = exception.getErrorCode();
        if (errorCode != null && this.failedMap.containsKey((Object)errorCode)) {
            BigDecimal val = this.failedMap.get((Object)errorCode);
            if (val == null) {
                val = BigDecimal.valueOf(0L);
            }
            val = val.add(BigDecimal.ONE);
            this.failedMap.put(errorCode, val);
            this.failed = this.failed.add(BigDecimal.ONE);
        }
    }

    @Override
    public void onConnectionException(Exception e) {
        this.connectionFailed = this.connectionFailed.add(BigDecimal.ONE);
    }

    public BigDecimal getReceivedAmount() {
        return this.receivedAmount;
    }

    public BigDecimal getResolved() {
        return this.resolved;
    }

    public BigDecimal getUnresolved() {
        return this.unresolved;
    }

    public BigDecimal getReceived() {
        return this.received;
    }

    public BigDecimal getFailed() {
        return this.failed;
    }

    public BigDecimal getConnectionFailed() {
        return this.connectionFailed;
    }

    public BigDecimal getFailureRatio() {
        BigDecimal all = this.received.add(this.failed);
        if (!this.failed.equals(BigDecimal.ZERO) && !all.equals(BigDecimal.ZERO)) {
            return this.failed.setScale(3, RoundingMode.HALF_UP).divide(all, RoundingMode.HALF_UP).multiply(HUNDRED).setScale(1, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getUnresolvedRatio() {
        BigDecimal all = this.unresolved.add(this.resolved);
        if (!this.unresolved.equals(BigDecimal.ZERO) && !all.equals(BigDecimal.ZERO)) {
            return this.unresolved.setScale(3, RoundingMode.HALF_UP).divide(all, RoundingMode.HALF_UP).multiply(HUNDRED).setScale(1, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }
}

