/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core;

import de.csdev.ebus.core.EBusControllerBase;
import de.csdev.ebus.core.EBusControllerException;
import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.core.EBusQueue;
import de.csdev.ebus.core.EBusReceiveStateMachine;
import de.csdev.ebus.core.IEBusController;
import de.csdev.ebus.core.connection.IEBusConnection;
import de.csdev.ebus.utils.EBusUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.BufferOverflowException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBusLowLevelController
extends EBusControllerBase {
    private static final Logger logger = LoggerFactory.getLogger(EBusLowLevelController.class);
    protected @NonNull IEBusConnection connection;
    private int reConnectCounter = 0;
    private long sendRoundTrip = -1L;

    public EBusLowLevelController(@NonNull IEBusConnection connection) {
        Objects.requireNonNull(connection, "connection");
        this.connection = connection;
    }

    @Override
    public long getLastSendReceiveRoundtripTime() {
        return this.sendRoundTrip;
    }

    public @NonNull IEBusConnection getConnection() throws EBusControllerException {
        if (!this.isRunning()) {
            throw new EBusControllerException();
        }
        return this.connection;
    }

    private void onEBusDataReceived(byte data) throws IOException {
        if (!this.isRunning()) {
            logger.trace("Skip event, thread was interrupted ...");
            return;
        }
        try {
            this.machine.update(data);
        }
        catch (EBusDataException e) {
            this.fireOnEBusDataException(e, e.getSendId());
        }
        if (this.machine.isWaitingForSlaveAnswer()) {
            logger.trace("waiting for slave answer ...");
        }
        if (this.machine.isSync()) {
            this.send(false);
            try {
                this.queue.checkSendStatus(false);
            }
            catch (EBusDataException e) {
                this.fireOnEBusDataException(e, e.getSendId());
            }
            if (this.machine.isTelegramAvailable()) {
                byte[] telegramData = this.machine.getTelegramData();
                this.fireOnEBusTelegramReceived(telegramData, null);
                this.machine.reset();
            }
        }
    }

    private void reconnect() throws IOException, InterruptedException {
        if (!this.isRunning()) {
            logger.trace("Skip reconnect, thread was interrupted ...");
            return;
        }
        logger.info("Try to reconnect to eBUS adapter ...");
        this.setConnectionStatus(IEBusController.ConnectionStatus.CONNECTING);
        if (this.reConnectCounter > 10) {
            this.reConnectCounter = -1;
            this.interrupt();
        } else {
            ++this.reConnectCounter;
            logger.warn("Retry to connect to eBUS adapter in {} seconds ...", (Object)(5 * this.reConnectCounter));
            Thread.sleep(5000L * (long)this.reConnectCounter);
            this.connection.close();
            if (this.connection.open()) {
                this.resetWatchdogTimer();
            }
        }
    }

    private boolean resend() {
        EBusQueue.QueueEntry entry = this.queue.getCurrent();
        if (this.isRunning() && entry != null && !entry.secondTry) {
            entry.secondTry = true;
            return true;
        }
        logger.warn("Resend failed, remove data from sending queue ...");
        this.queue.resetSendQueue();
        return false;
    }

    @Override
    public void run() {
        this.initThreadPool();
        int read = -1;
        byte[] buffer = new byte[100];
        try {
            if (!this.connection.isOpen()) {
                this.setConnectionStatus(IEBusController.ConnectionStatus.CONNECTING);
                this.connection.open();
            }
        }
        catch (IOException e) {
            logger.error("error!", (Throwable)e);
            this.fireOnConnectionException(e);
        }
        this.resetWatchdogTimer();
        while (!Thread.interrupted() && this.reConnectCounter != -1) {
            try {
                if (!this.connection.isOpen()) {
                    this.reconnect();
                    continue;
                }
                this.setConnectionStatus(IEBusController.ConnectionStatus.CONNECTED);
                read = this.connection.readBytes(buffer);
                if (read == -1) {
                    logger.debug("eBUS read timeout occured, no data on bus ...");
                    throw new IOException("End of eBUS stream reached!");
                }
                for (int i = 0; i < read; ++i) {
                    this.onEBusDataReceived(buffer[i]);
                }
                this.resetWatchdogTimer();
                this.reConnectCounter = 0;
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                logger.error("An IO exception has occured! Try to reconnect eBUS connector ...", (Throwable)e);
                this.fireOnConnectionException(e);
                try {
                    this.reconnect();
                }
                catch (IOException e1) {
                    logger.error(e.toString(), (Throwable)e1);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (BufferOverflowException e) {
                logger.error("eBUS telegram buffer overflow - not enough sync bytes received! Try to adjust eBUS adapter.");
                this.machine.reset();
            }
            catch (Exception e) {
                logger.error(e.toString(), (Throwable)e);
                this.machine.reset();
            }
        }
        try {
            this.dispose();
        }
        catch (InterruptedException e) {
            logger.error("error!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void send(boolean secondTry) throws IOException {
        block28: {
            if (!this.isRunning()) {
                logger.trace("Skip send, thread was interrupted ...");
                return;
            }
            if (!this.connection.isReceiveBufferEmpty()) {
                logger.trace("Receive buffer still not empty, skip ...");
                return;
            }
            EBusQueue.QueueEntry sendEntry = this.queue.getCurrent();
            if (sendEntry == null) {
                return;
            }
            try {
                byte b0;
                int i;
                byte[] dataOutputBuffers = sendEntry.buffer;
                EBusReceiveStateMachine sendMachine = new EBusReceiveStateMachine();
                logger.debug("Send: {} @ {}. attempt", (Object)EBusUtils.toHexDumpString(dataOutputBuffers), (Object)sendEntry.sendAttempts);
                sendMachine.update((byte)-86);
                ++sendEntry.sendAttempts;
                if (sendEntry.sendAttempts - 10 > sendEntry.maxAttemps) {
                    logger.error("emergency break!!!!");
                    this.queue.resetSendQueue();
                    return;
                }
                int read = 0;
                byte readByte = 0;
                this.connection.reset();
                byte b = dataOutputBuffers[0];
                if (logger.isTraceEnabled()) {
                    logger.trace("Send {}", (Object)EBusUtils.toHexDumpString(b));
                }
                long startTime = System.nanoTime();
                this.connection.writeByte(b);
                read = this.connection.readByte(true);
                readByte = (byte)(read & 0xFF);
                this.sendRoundTrip = System.nanoTime() - startTime;
                sendMachine.update(readByte);
                if (read == -1) {
                    logger.warn("End of stream reached for first byte. Stop sending attempt ...");
                    this.queue.setBlockNextSend(true);
                    return;
                }
                if (b != readByte) {
                    if (readByte == -86) {
                        logger.debug("eBUS collision with SYN detected!");
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("eBUS collision detected! 0x{}", (Object)EBusUtils.toHexDumpString(readByte));
                    }
                    if (this.queue.isLastSendCollisionDetected()) {
                        logger.warn("A second collision occured!");
                        this.queue.resetSendQueue();
                    } else if ((byte)(readByte & 0xF) == (byte)(b & 0xF)) {
                        logger.trace("Priority class match, restart after next SYN ...");
                        this.queue.setLastSendCollisionDetected(true);
                    } else {
                        logger.trace("Priority class doesn't match, blocked for next SYN ...");
                        this.queue.setBlockNextSend(true);
                    }
                    return;
                }
                for (i = 1; i < dataOutputBuffers.length; ++i) {
                    this.connection.writeByte(dataOutputBuffers[i]);
                }
                this.queue.setLastSendCollisionDetected(false);
                this.queue.setBlockNextSend(false);
                for (i = 1; i < dataOutputBuffers.length; ++i) {
                    read = this.connection.readByte(true);
                    byte b02 = dataOutputBuffers[i];
                    byte b1 = (byte)(read & 0xFF);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Send 0x{} -> Received 0x{}", (Object)EBusUtils.toHexDumpString(b02), (Object)EBusUtils.toHexDumpString(b1));
                    }
                    if (read == -1) {
                        logger.warn("End of stream reached. Stop sending attempt ...");
                        this.queue.setBlockNextSend(true);
                        return;
                    }
                    if (b02 != b1) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Received byte 0x{} is not equal to send byte 0x{}! Stop send attempt ...", (Object)EBusUtils.toHexDumpString(b1), (Object)EBusUtils.toHexDumpString(b02));
                        }
                        this.queue.setBlockNextSend(true);
                        return;
                    }
                    sendMachine.update(b1);
                }
                if (sendMachine.isWaitingForSlaveAnswer()) {
                    logger.trace("Waiting for slave answer ...");
                    while (!sendMachine.isWaitingForMasterACK() && !sendMachine.isWaitingForMasterSYN()) {
                        read = this.connection.readByte(true);
                        if (read == -1) continue;
                        byte ack = (byte)(read & 0xFF);
                        sendMachine.update(ack);
                    }
                    logger.trace("Slave answer received ...");
                }
                if (sendMachine.isWaitingForMasterACK()) {
                    logger.trace("Send Master ACK to Slave ...");
                    this.connection.writeByte(0);
                    b0 = (byte)(this.connection.readByte(true) & 0xFF);
                    sendMachine.update(b0);
                }
                if (sendMachine.isWaitingForMasterSYN()) {
                    logger.trace("Send SYN to bus ...");
                    this.connection.writeByte(-86);
                    b0 = (byte)(this.connection.readByte(true) & 0xFF);
                    sendMachine.update(b0);
                }
                if (sendMachine.isTelegramAvailable()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Succesful send: {}", (Object)sendMachine.toDumpString());
                    }
                    this.fireOnEBusTelegramReceived(sendMachine.getTelegramData(), sendEntry.id);
                }
                this.queue.resetSendQueue();
            }
            catch (EBusDataException e) {
                this.fireOnEBusDataException(e, sendEntry.id);
                if (!e.getErrorCode().equals((Object)EBusDataException.EBusError.SLAVE_ACK_FAIL)) break block28;
                this.resend();
            }
        }
    }

    @Override
    protected void dispose() throws InterruptedException {
        logger.info("eBUS connection thread is shuting down ...");
        this.setConnectionStatus(IEBusController.ConnectionStatus.DISCONNECTED);
        super.dispose();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
    }

    @Override
    protected void fireWatchDogTimer() {
        logger.warn("eBUS Watchdog Timer!");
        try {
            this.connection.close();
        }
        catch (IOException e) {
            logger.error("error!", (Throwable)e);
        }
    }
}

