/*
 * Decompiled with CFR 0.152.
 */
package de.csdev.ebus.core;

import de.csdev.ebus.core.EBusControllerException;
import de.csdev.ebus.core.EBusDataException;
import de.csdev.ebus.core.EBusQueue;
import de.csdev.ebus.core.EBusReceiveStateMachine;
import de.csdev.ebus.core.EBusWorkerThreadFactory;
import de.csdev.ebus.core.IEBusConnectorEventListener;
import de.csdev.ebus.core.IEBusController;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EBusControllerBase
extends Thread
implements IEBusController {
    private static final Logger logger = LoggerFactory.getLogger(EBusControllerBase.class);
    private static final String THREADPOOL_NOT_READY = "ThreadPool not ready!";
    protected @NonNull EBusReceiveStateMachine machine = new EBusReceiveStateMachine();
    private final @NonNull List<IEBusConnectorEventListener> listeners = new CopyOnWriteArrayList<IEBusConnectorEventListener>();
    private ExecutorService threadPool;
    private ScheduledExecutorService threadPoolWDT;
    private ScheduledFuture<?> watchdogTimer;
    private int watchdogTimerTimeout = 300;
    protected @NonNull EBusQueue queue = new EBusQueue();
    private @NonNull IEBusController.ConnectionStatus connectionStatus = IEBusController.ConnectionStatus.DISCONNECTED;

    @Override
    public @NonNull Integer addToSendQueue(byte @NonNull [] buffer, int maxAttemps) throws EBusControllerException {
        if (this.getConnectionStatus() != IEBusController.ConnectionStatus.CONNECTED) {
            throw new EBusControllerException("Controller not connected, unable to add telegrams to send queue!");
        }
        Integer sendId = this.queue.addToSendQueue(buffer, maxAttemps);
        if (sendId == null) {
            throw new EBusControllerException("Unable to add telegrams to send queue!");
        }
        return sendId;
    }

    @Override
    public @NonNull Integer addToSendQueue(byte @NonNull [] buffer) throws EBusControllerException {
        if (this.getConnectionStatus() != IEBusController.ConnectionStatus.CONNECTED) {
            throw new EBusControllerException("Controller not connected, unable to add telegrams to send queue!");
        }
        Integer sendId = this.queue.addToSendQueue(buffer);
        if (sendId == null) {
            throw new EBusControllerException("Unable to add telegrams to send queue!");
        }
        return sendId;
    }

    @Override
    public void addEBusEventListener(@NonNull IEBusConnectorEventListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public boolean removeEBusEventListener(@NonNull IEBusConnectorEventListener listener) {
        Objects.requireNonNull(listener);
        return this.listeners.remove(listener);
    }

    protected void fireOnConnectionException(@NonNull Exception e) {
        Objects.requireNonNull(e);
        if (!this.isRunning()) {
            return;
        }
        if (this.threadPool == null || this.threadPool.isTerminated()) {
            logger.warn(THREADPOOL_NOT_READY);
            return;
        }
        this.threadPool.execute(() -> {
            for (IEBusConnectorEventListener listener : this.listeners) {
                if (Thread.interrupted()) continue;
                try {
                    listener.onConnectionException(e);
                }
                catch (Exception e1) {
                    logger.error("Error while firing onConnectionException events!", (Throwable)e1);
                }
            }
        });
    }

    protected void fireOnEBusTelegramReceived(byte @NonNull [] receivedData, Integer sendQueueId) {
        if (!this.isRunning()) {
            return;
        }
        if (this.threadPool == null || this.threadPool.isTerminated()) {
            logger.warn("ThreadPool not ready! Can't fire onTelegramReceived events ...");
            return;
        }
        if (receivedData.length == 0) {
            logger.warn("Telegram data is empty! Can't fire onTelegramReceived events ...");
            return;
        }
        this.threadPool.execute(() -> {
            for (IEBusConnectorEventListener listener : this.listeners) {
                if (Thread.interrupted()) continue;
                try {
                    listener.onTelegramReceived(receivedData, sendQueueId);
                }
                catch (Exception e) {
                    logger.error("Error while firing onTelegramReceived events!", (Throwable)e);
                }
            }
        });
    }

    protected void fireOnEBusDataException(@NonNull EBusDataException exception, Integer sendQueueId) {
        Objects.requireNonNull(exception);
        if (!this.isRunning()) {
            return;
        }
        if (this.threadPool == null || this.threadPool.isTerminated()) {
            logger.warn(THREADPOOL_NOT_READY);
            return;
        }
        this.threadPool.execute(() -> {
            for (IEBusConnectorEventListener listener : this.listeners) {
                if (Thread.interrupted()) continue;
                try {
                    listener.onTelegramException(exception, sendQueueId);
                }
                catch (Exception e) {
                    logger.error("Error while firing onTelegramException events!", (Throwable)e);
                }
            }
        });
    }

    protected void fireOnEBusConnectionStatusChange(@NonNull IEBusController.ConnectionStatus status) {
        Objects.requireNonNull(status);
        if (!this.isRunning()) {
            return;
        }
        if (this.threadPool == null || this.threadPool.isTerminated()) {
            logger.warn(THREADPOOL_NOT_READY);
            return;
        }
        this.threadPool.execute(() -> {
            for (IEBusConnectorEventListener listener : this.listeners) {
                try {
                    listener.onConnectionStatusChanged(status);
                }
                catch (Exception e) {
                    logger.error("Error while firing fireOnEBusConnectionStatusChange events!", (Throwable)e);
                }
            }
        });
    }

    protected void initThreadPool() {
        this.threadPool = new ThreadPoolExecutor(5, 60, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new EBusWorkerThreadFactory("ebus-receiver", true));
        this.threadPoolWDT = Executors.newSingleThreadScheduledExecutor(new EBusWorkerThreadFactory("ebus-wdt", false));
    }

    protected void shutdownThreadPool() throws InterruptedException {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdownNow();
        }
        if (this.threadPoolWDT != null && !this.threadPoolWDT.isShutdown()) {
            this.threadPoolWDT.shutdownNow();
        }
        if (this.threadPool != null) {
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
            this.threadPool = null;
        }
        if (this.threadPoolWDT != null) {
            this.threadPoolWDT.awaitTermination(10L, TimeUnit.SECONDS);
            this.threadPoolWDT = null;
        }
    }

    @Override
    public boolean isRunning() {
        return !this.isInterrupted() && this.isAlive();
    }

    protected void dispose() throws InterruptedException {
        this.listeners.clear();
        if (this.watchdogTimer != null) {
            this.watchdogTimer.cancel(true);
            this.watchdogTimer = null;
        }
        this.shutdownThreadPool();
    }

    protected void resetWatchdogTimer() {
        Runnable r = this::fireWatchDogTimer;
        if (this.watchdogTimer != null && !this.watchdogTimer.isCancelled()) {
            this.watchdogTimer.cancel(true);
        }
        if (!this.threadPoolWDT.isShutdown()) {
            this.watchdogTimer = this.threadPoolWDT.schedule(r, (long)this.watchdogTimerTimeout, TimeUnit.SECONDS);
        }
    }

    @Override
    public void setWatchdogTimerTimeout(int seconds) {
        this.watchdogTimerTimeout = seconds;
    }

    protected abstract void fireWatchDogTimer();

    protected void setConnectionStatus(@NonNull IEBusController.ConnectionStatus status) {
        Objects.requireNonNull(status, "status");
        if (this.connectionStatus != status) {
            this.connectionStatus = status;
            this.fireOnEBusConnectionStatusChange(status);
        }
    }

    @Override
    public @NonNull IEBusController.ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    public void run() {
        throw new IllegalStateException("Method run() should be overwritten!");
    }
}

